<?php

namespace App\Repository;

use App\Entity\Restaurant;
use App\Repository\Interface\RestaurantRepositoryInterface;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<Restaurant>
 *
 * @method Restaurant|null find($id, $lockMode = null, $lockVersion = null)
 * @method Restaurant|null findOneBy(array $criteria, array $orderBy = null)
 * @method Restaurant[]    findAll()
 * @method Restaurant[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class RestaurantRepository extends ServiceEntityRepository implements RestaurantRepositoryInterface
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Restaurant::class);
    }

    public function getAll($page, $limit, $restaurantTypeId, $kitchenId): array
    {
        $query = $this->createQueryBuilder('r');
        $query->select('r');
        if ($restaurantTypeId !== null) {
            $query->andWhere('r.typeId = :restaurantTypeId')
                ->setParameter('restaurantTypeId', $restaurantTypeId);
        }
        if ($kitchenId !== null) {
            $query->join('r.kitchen', 'k')
            ->andWhere('k.id = :kitchenId')
                ->setParameter('kitchenId', $kitchenId);
        }
        $query->setMaxResults($limit)
        ->setFirstResult(($page - 1) * $limit);
        return $query->getQuery()->getResult();
    }

    public function getCount(): int
    {
        return $this->count();
    }

    public function getById(int $id): Restaurant|null
    {
        return $this->find($id);
    }
}
