<?php

namespace App\Model;

class RestaurantListingElement
{
    private int $id;
    private string $name;
    private string $code;
    private RestaurantType $type;
    private string $check;
    private File $image;
    private string $detailLink;

    public function __construct(
        int $id,
        string $name,
        string $code,
        RestaurantType $type,
        string $check,
        File $image,
        string $detailLink
    ) {
        $this->id = $id;
        $this->name = $name;
        $this->code = $code;
        $this->type = $type;
        $this->check = $check;
        $this->image = $image;
        $this->detailLink = $detailLink;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function getCode(): string
    {
        return $this->code;
    }

    public function getType(): RestaurantType
    {
        return $this->type;
    }

    public function getCheck(): string
    {
        return $this->check;
    }

    public function getImage(): File
    {
        return $this->image;
    }

    public function getDetailLink(): string
    {
        return $this->detailLink;
    }
}