<?php

namespace App\Model;

use Ramsey\Collection\Collection;

class NewsList
{
    private Pagination $pagination;
    /**
     * @var Collection<NewsListingElement>
     */
    private Collection $list;
    private NewsFilterVariants $filterVariants;

    public function __construct(
        Pagination $pagination,
        Collection $list,
        NewsFilterVariants $filterVariants
    ) {
        $this->pagination = $pagination;
        $this->list = $list;
        $this->filterVariants = $filterVariants;
    }

    public function getPagination(): Pagination
    {
        return $this->pagination;
    }

    public function getList(): Collection
    {
        return $this->list;
    }

    public function getFilterVariants(): NewsFilterVariants
    {
        return $this->filterVariants;
    }
}