<?php

namespace App\DataFixtures;

use App\Entity\Restaurant;
use App\Entity\Tags;
use DateTime;
use App\Entity\Address;
use App\Entity\Email;
use App\Entity\Kitchen;
use App\Entity\Phone;
use App\Entity\RestaurantType;
use App\Entity\Settlement;
use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Persistence\ObjectManager;
use Symfony\Component\Uid\Uuid;

class RestaurantDataFixtures extends Fixture
{
    public function load(ObjectManager $manager)
    {
        $restaurantType = (new RestaurantType())
            ->setName("Ресторан")
            ->setCode("restoran");
        $settlement = (new Settlement())
            ->setUuid(Uuid::v4())
            ->setName("г. Тюмень")
            ->setCode("tyumen")
            ->setCoordinates([142, 214])
            ->setCreateAt(new DateTime("02-12-2023"))
            ->setUpdateAt(new DateTime("05-12-2023"));
        $restaurant = (new Restaurant())
            ->setUuid(Uuid::v4())
            ->setName("Ресторан «Арктика»")
            ->setCode("restoran-arktika")
            ->setCoordinates([123, 321])
            ->setCreateAt(new DateTime("12-02-2024"))
            ->setUpdateAt(new DateTime("09-03-2024"))
            ->setActive(true)
            ->setCheckPrice("от 1 до 2 || от 1 || до 1000")
            ->setCheckInfo("bla bla")
            ->setDescription("Описание ресторана Описание ресторана")
            ->setHowToFind("Возле набережной")
            ->setPreviewImage("/upload/preview.png")
            ->setDetailImage("/upload/detail.png")
            ->setTypeId($restaurantType)
            ->setSettlementId($settlement)
            ->setSite("https://visityamal.ru/")
            ->setSort(1);
        $phone = (new Phone())
            ->setName("7999999999")
            ->setRestaurant($restaurant);
        $email = (new Email())
            ->setName("test@mail.ru")
            ->setRestaurant($restaurant);
        $address = (new Address())
            ->setName("ул.Пушкина дом Колотушкина")
            ->setRestaurant($restaurant);
        $kitchen = (new Kitchen())
            ->setName("Азиатская")
            ->setRestaurant($restaurant);
        $tags = (new Tags())
            ->setName("тег1")
            ->setRestaurant($restaurant);
        $manager->persist($restaurantType);
        $manager->persist($settlement);
        $manager->persist($restaurant);
        $manager->persist($phone);
        $manager->persist($email);
        $manager->persist($address);
        $manager->persist($kitchen);
        $manager->persist($tags);
        $manager->flush();
    }
}