<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

class HomeController extends AbstractController
{
    private function prepareMenu(array $aMenu): array {
        $result = [];
        foreach ($aMenu as $arr) {
            if ($arr['depth'] === 0) {
                $result[] = array(
                    'name' => $arr['name'],
                    'depth' => $arr['depth'],
                    'submenu' => []
                );
                continue;
            }
            $result[array_key_last($result)]['submenu'][] = array(
                'name' => $arr['name'],
                'depth' => $arr['depth'],
            );
        }
        return $result;
    }


    #[Route('/', name: 'home')]
    public function home(): Response
    {
        $aMenu = [
            ['name' => 'Смартфоны и гаджеты','depth' => 0,],
            ['name' => 'Смартфоны, мобильные телефоны','depth' => 1,],
            ['name' => 'Планшеты','depth' => 1,],
            ['name' => 'Наушники и гарнитуры','depth' => 1,],
            ['name' => 'Компьютеры и ноутбуки','depth' => 0,],
            ['name' => 'Ноутбуки и аксессуары','depth' => 1,],
            ['name' => 'Компьютеры и мониторы','depth' => 1,],
            ['name' => 'Компьютерные комплектующие','depth' => 1,],
            ['name' => 'Техника для дома','depth' => 0,],
            ['name' => 'Техника для уборки','depth' => 1,],
            ['name' => 'Товары для ухода за одеждой','depth' => 1,],
            ['name' => 'Аксессуары для техники','depth' => 1,],
            ['name' => 'Товары для дома и кухни','depth' => 0,],
            ['name' => 'Посуда','depth' => 1,],
        ];

        return $this->render('home.html.twig', ['menu' => $this->prepareMenu($aMenu)]);
    }
}
