<?php

namespace App\Controller;

use DateInterval;
use DatePeriod;
use DateTime;
use DateTimeImmutable;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

class HomeController extends AbstractController
{
    private function readLogFile(string $fileName): string {
        $filePath = $this->getParameter('kernel.project_dir') . "/public/files/" . $fileName;
        if (file_exists($filePath)) {
            $text = "";
            $file = fopen($filePath, "r");
            while(!feof($file)) {
                $line = fgets($file);
                $text .= $line;
            }
            fclose($file);
            return $text;
        }
        return "Такого файла не существует.";
    }


    #[Route('/{fileName}', name: 'home')]
    public function home(string $fileName): Response // text.txt
    {
        $text = $this->readLogFile($fileName);
        return $this->render('home.html.twig', ['text' => $text]);
    }
}
