<?php

declare(strict_types=1);

namespace App\Action;

class Functions
{
    /**
     * Выполняет сортировку массива по убыванию цены
     * @param array $array
     * @return array
     */

    public function sortPrice(array $array): array
    {
        $prices = array_column($array, 'price');
        $counts = array_column($array, 'count');
        array_multisort(
            $prices,
            SORT_DESC,
            $counts,
            SORT_ASC, $array
        );
        return $array;
    }

    /**
     * На выход должна вернуть отсортированный массив по ключу *price* DESC
     * и во вторую очередь по *count* ASC:
     * [['price'=>12, 'count'=>4],  ['price'=>10, 'count'=>2],  ['price'=>8, 'count'=>4],
     * ['price'=>8, 'count'=>5],  ['price'=>5, 'count'=>5],]
     */

    /**
     * Найдет элемент с указаным id
     * @param array $array - массив, содержащий элементы со структурой
     * [
     *  'id' => 30,
     *  'name' => 'Jhon',
     *  'age' => 23,
     * ]
     * @param $id - ид искомого элемента
     * @return ?array - найденный элемент
     */

    public function search(array $array, int $id): ?array
    {
        $rowId = array_search($id, array_column($array, 'id'), false);
        if ($rowId !== false) {
            return $array[$rowId];
        }
        return null;
    }

    /**
     * Удалить дубликаты, оставив только уникальные значения
     * @param array $array
     * @return array
     */

    public function uniqElements(array $array): array
    {
        return array_unique($array, SORT_REGULAR);
    }

    /**
      * Выходной массив:
      * Array (
      *   [0] => Array([0] => laravel, [1] => php)
      *   [1] => Array([0] => codeigniter, [1] => php)
      *   [3] => Array([0] => c++, [1] => java))
      * )
      */
}