<?php

namespace App\Validation;

class ArrayValidation
{
    public static function validateFunc1(array $array): bool
    {
        $prices = array_column($array, 'price');
        $counts = array_column($array, 'count');
        return ctype_digit(implode('',$prices)) && ctype_digit(implode('', $counts));
    }

    public static function validate(array $array): ConstraintViolationListInterface
    {
        $validator = Validation::createValidator();
        $constraints = new Assert\Optional([
            new Assert\Collection([
                new Assert\Optional([
                    new Assert\Type('array'),
                    new Assert\Collection([
                        'id' => new Assert\Type('int'),
                        'name' => new Assert\Type('string'),
                        'age' => new Assert\Type('int'),
                    ])
                ])
            ])
        ]);
        return $validator->validate($array, $constraints);
    }
}