<?php

namespace App\Controller;

use App\Action\Functions;
use App\Validation\ArrayValidation;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Attribute\Route;

class HomeController extends AbstractController
{
    private Functions $functions;

    public function __construct(Functions $functions)
    {
        $this->functions = $functions;
    }

    #[Route('/func1', name: 'home', methods: ['POST'])]
    public function func1(Request $request): Response
    {
        $array = $request->get('arr');
        if (!ArrayValidation::validateFunc1($array)) {
            return new Response("Invalid array");
        }
        $array = $this->functions->sortPrice($array);
        return $this->json($array);
    }

    #[Route('/', name: 'home', methods: ['POST'])]
    public function home(Request $request): Response
    {
        $id = $request->query->getInt('id');
        $array = $request->get('arr');
        $errors = ArrayValidation::validate($array);
        if (count($errors) > 0) {
            return new Response((string)$errors);
        }
        $result = $this->functions->search($array, $id);
        return $this->json($result);
    }
}
