<?php

namespace App\Service;

use Exception;
use App\Exception\NewsExceptionEnum;
use App\Mapper\NewsMapper;
use App\Model\NewsDetailElement;
use App\Model\NewsList;
use App\Model\NewsListingElement;
use App\Repository\Interface\NewsCategoryRepositoryInterface;
use App\Repository\Interface\NewsRepositoryInterface;

class NewsService
{
    public function __construct(
        private NewsRepositoryInterface $newsRepository,
        private NewsCategoryRepositoryInterface $newsCategoryRepository) {}

    public function getNews($page, $limit, $newsCategory): NewsList
    {
        $news = $this->newsRepository->getAll($page, $limit, $newsCategory);
        $newsCategories = $this->newsCategoryRepository->getAll();
        $count = $this->newsRepository->getCount();
        return NewsMapper::mapToNewsList($news, $newsCategories, $page, $limit, $count);
    }

    public function getMainNews(): NewsListingElement
    {
        $mainNews = $this->newsRepository->getMainNews();
        return NewsMapper::mapToListingElement($mainNews);
    }

    public function getNewsSearch(): NewsDetailElement
    {
        $mainNews = $this->newsRepository->getMainNews();
        return NewsMapper::mapToDetailElement($mainNews);
    }

    public function getNewsOne($newsId): NewsDetailElement
    {
        $news = $this->newsRepository->getNewsById($newsId);
        if ($news == null) {
            throw new Exception("News not found", NewsExceptionEnum::NotFound->value);
        }
        return NewsMapper::mapToDetailElement($news);
    }
}