<?php

namespace App\Repository;

use App\Entity\Kitchen;
use App\Repository\Interface\KitchenRepositoryInterface;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<Kitchen>
 *
 * @method Kitchen|null find($id, $lockMode = null, $lockVersion = null)
 * @method Kitchen|null findOneBy(array $criteria, array $orderBy = null)
 * @method Kitchen[]    findAll()
 * @method Kitchen[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class KitchenRepository extends ServiceEntityRepository implements  KitchenRepositoryInterface
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Kitchen::class);
    }

    public function getAll(): array
    {
        return $this->findAll();
    }
}
