<?php

namespace App\Model;

use DateTime;

class Review
{
    private int $id;
    private DateTime $date;
    private int $score;
    private string $text;
    private string $userName;

    public function __construct(
        int $id,
        DateTime $date,
        int $score,
        string $text,
        string $userName
    ) {
        $this->id = $id;
        $this->date = $date;
        $this->score = $score;
        $this->text = $text;
        $this->userName = $userName;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function getDate(): DateTime
    {
        return $this->date;
    }

    public function getScore(): int
    {
        return $this->score;
    }

    public function getText(): string
    {
        return $this->text;
    }

    public function getUserName(): string
    {
        return $this->userName;
    }
}