<?php

namespace App\Model;

use Symfony\Component\Uid\Uuid;

class NewsDetailElement
{
    private Uuid $id;
    private string $name;
    private string $description;
    private string $text;
    private File $image;
    private string $createAt;
    private string $seoTitle;
    private string $seoDescription;
    private string $seoKeywords;

    public function __construct(
        Uuid   $id,
        string $name,
        string $description,
        string $text,
        File   $image,
        string $createAt,
        string $seoTitle,
        string $seoDescription,
        string $seoKeywords
    ) {
        $this->id = $id;
        $this->name = $name;
        $this->description = $description;
        $this->text = $text;
        $this->image = $image;
        $this->createAt = $createAt;
        $this->seoTitle = $seoTitle;
        $this->seoDescription = $seoDescription;
        $this->seoKeywords = $seoKeywords;
    }

    public function getId(): Uuid
    {
        return $this->id;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function getDescription(): string
    {
        return $this->description;
    }

    public function getText(): string
    {
        return $this->text;
    }

    public function getImage(): File
    {
        return $this->image;
    }

    public function getCreateAt(): string
    {
        return $this->createAt;
    }

    public function getSeoTitle(): string
    {
        return $this->seoTitle;
    }

    public function getSeoDescription(): string
    {
        return $this->seoDescription;
    }

    public function getSeoKeywords(): string
    {
        return $this->seoKeywords;
    }
}