<?php

namespace App\DataFixtures;

use App\Entity\File;
use App\Entity\Gallery;
use App\Entity\Restaurant;
use App\Entity\Seo;
use App\Entity\Tags;
use DateTime;
use App\Entity\Kitchen;
use App\Entity\RestaurantType;
use App\Entity\Settlement;
use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Persistence\ObjectManager;

class RestaurantDataFixtures extends Fixture
{
    public function load(ObjectManager $manager)
    {
        $restaurantType = (new RestaurantType())
            ->setName("Ресторан")
            ->setCode("restoran");
        $settlement = (new Settlement())
            ->setName("г. Тюмень")
            ->setCode("tyumen")
            ->setCoordinates([142, 214])
            ->setCreateAt(new DateTime("02-12-2023"))
            ->setUpdateAt(new DateTime("05-12-2023"));
        $seo = (new Seo())
            ->setTitle("Отель Арктика")
            ->setDescription("otel-arktika")
            ->setKeywords("otel-arktika");
        $file = (new File())
            ->setName("asd")
            ->setDescription("Краткое описание")
            ->setType("png")
            ->setUrl("/upload/asd.png")
            ->setSize(1024);
        $gallery = (new Gallery())
            ->setFile($file)
        $restaurant = (new Restaurant())
            ->setName("Ресторан «Арктика»")
            ->setCode("restoran-arktika")
            ->setCoordinates([123, 321])
            ->setCreateAt(new DateTime("12-02-2024"))
            ->setUpdateAt(new DateTime("09-03-2024"))
            ->setActive(true)
            ->setCheckPrice("от 1 до 2 || от 1 || до 1000")
            ->setCheckInfo("bla bla")
            ->setDescription("Описание ресторана Описание ресторана")
            ->setHowToFind("Возле набережной")
            ->setPreviewImage("/upload/preview.png")
            ->setDetailImage("/upload/detail.png")
            ->setTypeId($restaurantType)
            ->setSettlementId($settlement)
            ->setSite("https://visityamal.ru/")
            ->setSort(1)
            ->setPhone(["7999999999"])
            ->setEmail(["test@mail.ru"])
            ->setAddress(["ул.Пушкина дом Колотушкина"])
            ->setSeo($seo)
            ->addGallery();
        $kitchen = (new Kitchen())
            ->setName("Азиатская")
            ->setRestaurant($restaurant);
        $tags = (new Tags())
            ->setName("группа тегов 1")
            ->setList(["тег1", "тег2"])
            ->setRestaurant($restaurant);
        $manager->persist($restaurantType);
        $manager->persist($seo);
        $manager->persist($settlement);
        $manager->persist($restaurant);
        $manager->persist($kitchen);
        $manager->persist($tags);
        $manager->flush();
    }
}