<?php

namespace App\DataFixtures;

use DateTime;
use App\Entity\News;
use App\Entity\NewsType;
use App\Entity\NewsCategory;
use App\Entity\User;
use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Persistence\ObjectManager;
use Symfony\Component\Uid\Uuid;

class NewsDataFixtures extends Fixture
{
    public function load(ObjectManager $manager)
    {
        $newsType = (new NewsType())
            ->setName("Статья");
        $newsCategory = (new NewsCategory())
            ->setId(Uuid::v4())
            ->setName("Культура")
            ->setCode("kultura");
        $user = (new User())
            ->setName("Модератор")
            ->setUuid(Uuid::v4());
        $news = (new News())
            ->setId(Uuid::v4())
            ->setSort(1)
            ->setActive(true)
            ->setDetailImage("/upload/news-detail.jpg")
            ->setPreviewImage("/upload/news-preview.jpg")
            ->setType($newsType)
            ->setCreateAt(new DateTime("23-04-2024"))
            ->setCode("yamal-museum")
            ->setUpdateAt(new DateTime("23-04-2024"))
            ->setDetailText("Это самый большой музей на Ямале.  Здесь вы найдете всё о жизни региона, традициях и обычаях народов севера и посетите виртуальную выставку, организованную по последнему слову современных технологий.")
            ->setMainPageRender(true)
            ->setPreviewText("Два часа на знакомство с тысячелетней историей  Ямала.")
            ->addNewsCategory($newsCategory);
        $manager->persist($newsType);
        $manager->persist($newsCategory);
        $manager->persist($user);
        $manager->persist($news);
        $manager->flush();

    }
}