<?php

namespace App\Entity;

use App\Repository\NewsRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Bridge\Doctrine\Types\UuidType;
use Symfony\Component\Uid\Uuid;

#[ORM\Entity(repositoryClass: NewsRepository::class)]
class News
{
    #[ORM\Id]
    #[ORM\Column(type: UuidType::NAME, unique: true)]
    #[ORM\GeneratedValue(strategy: 'CUSTOM')]
    #[ORM\CustomIdGenerator(class: 'doctrine.uuid_generator')]
    private ?Uuid $id = null;

    #[ORM\Column(length: 255)]
    private ?string $code = null;

    #[ORM\Column]
    private ?bool $active = null;

    #[ORM\Column(type: Types::DATETIME_IMMUTABLE)]
    private ?\DateTimeInterface $createAt = null;

    #[ORM\Column(type: Types::DATETIME_IMMUTABLE)]
    private ?\DateTimeInterface $updateAt = null;

    #[ORM\Column]
    private ?int $sort = null;

    #[ORM\Column(length: 255)]
    private ?string $previewImage = null;

    #[ORM\Column(length: 255)]
    private ?string $detailImage = null;

    #[ORM\Column(type: Types::TEXT)]
    private ?string $previewText = null;

    #[ORM\Column(type: Types::TEXT)]
    private ?string $detailText = null;

    #[ORM\ManyToOne(inversedBy: 'news')]
    #[ORM\JoinColumn(nullable: false)]
    private ?NewsType $type = null;

    #[ORM\Column]
    private ?bool $mainPageRender = null;

    /**
     * @var Collection<Uuid, NewsCategory>
     */
    #[ORM\ManyToMany(targetEntity: NewsCategory::class, inversedBy: "newsCategories")]
    private Collection $newsCategories;

    #[ORM\ManyToOne]
    #[ORM\JoinColumn(nullable: false)]
    private ?Seo $seo = null;

    #[ORM\OneToOne(cascade: ['persist', 'remove'])]
    #[ORM\JoinColumn(nullable: false)]
    private ?File $file = null;

    public function __construct()
    {
        $this->newsCategories = new ArrayCollection();
    }

    public function getId(): ?Uuid
    {
        return $this->id;
    }

    public function setId(?Uuid $id): static
    {
        $this->id = $id;
        return $this;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(string $code): static
    {
        $this->code = $code;

        return $this;
    }

    public function isActive(): ?bool
    {
        return $this->active;
    }

    public function setActive(bool $active): static
    {
        $this->active = $active;

        return $this;
    }

    public function getCreateAt(): ?\DateTimeInterface
    {
        return $this->createAt;
    }

    public function setCreateAt(\DateTimeInterface $createAt): static
    {
        $this->createAt = $createAt;

        return $this;
    }

    public function getUpdateAt(): ?\DateTimeInterface
    {
        return $this->updateAt;
    }

    public function setUpdateAt(\DateTimeInterface $updateAt): static
    {
        $this->updateAt = $updateAt;

        return $this;
    }

    public function getSort(): ?int
    {
        return $this->sort;
    }

    public function setSort(int $sort): static
    {
        $this->sort = $sort;

        return $this;
    }

    public function getPreviewImage(): ?string
    {
        return $this->previewImage;
    }

    public function setPreviewImage(string $previewImage): static
    {
        $this->previewImage = $previewImage;

        return $this;
    }

    public function getDetailImage(): ?string
    {
        return $this->detailImage;
    }

    public function setDetailImage(string $detailImage): static
    {
        $this->detailImage = $detailImage;

        return $this;
    }

    public function getPreviewText(): ?string
    {
        return $this->previewText;
    }

    public function setPreviewText(string $previewText): static
    {
        $this->previewText = $previewText;

        return $this;
    }

    public function getDetailText(): ?string
    {
        return $this->detailText;
    }

    public function setDetailText(string $detailText): static
    {
        $this->detailText = $detailText;

        return $this;
    }

    public function getType(): ?NewsType
    {
        return $this->type;
    }

    public function setType(?NewsType $type): static
    {
        $this->type = $type;

        return $this;
    }

    public function isMainPageRender(): ?bool
    {
        return $this->mainPageRender;
    }

    public function setMainPageRender(bool $mainPageRender): static
    {
        $this->mainPageRender = $mainPageRender;

        return $this;
    }

    /**
     * @return Collection<Uuid, NewsCategory>
     */
    public function getNewsCategories(): Collection
    {
        return $this->newsCategories;
    }

    public function addNewsCategory(NewsCategory $newsCategory): static
    {
        if (!$this->newsCategories->contains($newsCategory)) {
            $this->newsCategories->add($newsCategory);
        }

        return $this;
    }

    public function removeNewsCategory(NewsCategory $newsCategory): static
    {
        $this->newsCategories->removeElement($newsCategory);

        return $this;
    }

    public function getSeo(): ?Seo
    {
        return $this->seo;
    }

    public function setSeo(?Seo $seo): static
    {
        $this->seo = $seo;

        return $this;
    }

    public function getFile(): ?File
    {
        return $this->file;
    }

    public function setFile(File $file): static
    {
        $this->file = $file;

        return $this;
    }
}
