<?php

declare(strict_types=1);

namespace App\Controller;

use App\Requests\NewsListRequest;
use Exception;
use App\Service\NewsService;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Attribute\Route;

#[Route("/api/v1")]
class NewsController extends AbstractController
{
    public function __construct(private NewsService $newsService) {}

    #[Route('/news', name: 'news', methods: ['GET'])]
    public function news(NewsListRequest $request): Response
    {
        $page = $request->getRequest()->query->get('page');
        $limit = $request->getRequest()->query->get('limit');
        $newsCategory = $request->getRequest()->query->get('news_category');
        $news = $this->newsService->getNews($page, $limit, $newsCategory);
        return $this->json($news);
    }

    #[Route('/news/mainNews', name: 'mainNews', methods: ['GET'])]
    public function mainNews(): Response
    {
        $mainNews = $this->newsService->getMainNews();
        return $this->json($mainNews);
    }

    #[Route('/news/search', name: 'newsSearch', methods: ['GET'])]
    public function newsSearch(): Response
    {
        $newsSearch = $this->newsService->getNewsSearch();
        return $this->json($newsSearch);
    }

    #[Route('/news/{newsId}', name: 'newsOne', methods: ['GET'])]
    public function newsOne(Request $request): Response
    {
        try {
            $newsId = $request->get('newsId');;
            $news = $this->newsService->getNewsOne($newsId);
            return $this->json($news);
        } catch (Exception $e) {
            return new Response($e->getMessage(), $e->getCode());
        }
    }
}
