<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20240502094853 extends AbstractMigration
{
    public function getDescription(): string
    {
        return '';
    }

    public function up(Schema $schema): void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->addSql('DROP SEQUENCE gallery_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE seo_id_seq CASCADE');
        $this->addSql('CREATE TABLE file (id UUID NOT NULL, name VARCHAR(255) NOT NULL, description VARCHAR(255) NOT NULL, size INT NOT NULL, type VARCHAR(255) NOT NULL, url VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('COMMENT ON COLUMN file.id IS \'(DC2Type:uuid)\'');
        $this->addSql('CREATE TABLE gallery (id UUID NOT NULL, restaurant_id UUID NOT NULL, file_id UUID NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE UNIQUE INDEX UNIQ_472B783AB1E7706E ON gallery (restaurant_id)');
        $this->addSql('CREATE UNIQUE INDEX UNIQ_472B783A93CB796C ON gallery (file_id)');
        $this->addSql('COMMENT ON COLUMN gallery.id IS \'(DC2Type:uuid)\'');
        $this->addSql('COMMENT ON COLUMN gallery.restaurant_id IS \'(DC2Type:uuid)\'');
        $this->addSql('COMMENT ON COLUMN gallery.file_id IS \'(DC2Type:uuid)\'');
        $this->addSql('CREATE TABLE kitchen (id UUID NOT NULL, restaurant_id UUID NOT NULL, name VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_EAA3CE34B1E7706E ON kitchen (restaurant_id)');
        $this->addSql('COMMENT ON COLUMN kitchen.id IS \'(DC2Type:uuid)\'');
        $this->addSql('COMMENT ON COLUMN kitchen.restaurant_id IS \'(DC2Type:uuid)\'');
        $this->addSql('CREATE TABLE news (id UUID NOT NULL, type_id UUID NOT NULL, seo_id UUID NOT NULL, file_id UUID NOT NULL, code VARCHAR(255) NOT NULL, active BOOLEAN NOT NULL, create_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, update_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, sort INT NOT NULL, preview_image VARCHAR(255) NOT NULL, detail_image VARCHAR(255) NOT NULL, preview_text TEXT NOT NULL, detail_text TEXT NOT NULL, main_page_render BOOLEAN NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_1DD39950C54C8C93 ON news (type_id)');
        $this->addSql('CREATE INDEX IDX_1DD3995097E3DD86 ON news (seo_id)');
        $this->addSql('CREATE UNIQUE INDEX UNIQ_1DD3995093CB796C ON news (file_id)');
        $this->addSql('COMMENT ON COLUMN news.id IS \'(DC2Type:uuid)\'');
        $this->addSql('COMMENT ON COLUMN news.type_id IS \'(DC2Type:uuid)\'');
        $this->addSql('COMMENT ON COLUMN news.seo_id IS \'(DC2Type:uuid)\'');
        $this->addSql('COMMENT ON COLUMN news.file_id IS \'(DC2Type:uuid)\'');
        $this->addSql('COMMENT ON COLUMN news.create_at IS \'(DC2Type:datetime_immutable)\'');
        $this->addSql('COMMENT ON COLUMN news.update_at IS \'(DC2Type:datetime_immutable)\'');
        $this->addSql('CREATE TABLE news_news_category (news_id UUID NOT NULL, news_category_id UUID NOT NULL, PRIMARY KEY(news_id, news_category_id))');
        $this->addSql('CREATE INDEX IDX_1A91D6D6B5A459A0 ON news_news_category (news_id)');
        $this->addSql('CREATE INDEX IDX_1A91D6D63B732BAD ON news_news_category (news_category_id)');
        $this->addSql('COMMENT ON COLUMN news_news_category.news_id IS \'(DC2Type:uuid)\'');
        $this->addSql('COMMENT ON COLUMN news_news_category.news_category_id IS \'(DC2Type:uuid)\'');
        $this->addSql('CREATE TABLE news_category (id UUID NOT NULL, name VARCHAR(255) NOT NULL, code VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('COMMENT ON COLUMN news_category.id IS \'(DC2Type:uuid)\'');
        $this->addSql('CREATE TABLE news_comment (id UUID NOT NULL, news_id_id UUID NOT NULL, moderator_id_id UUID NOT NULL, user_id_id UUID NOT NULL, moderated BOOLEAN NOT NULL, user_name VARCHAR(255) NOT NULL, text VARCHAR(255) NOT NULL, create_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, update_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE UNIQUE INDEX UNIQ_C3904E8A5FB1909 ON news_comment (news_id_id)');
        $this->addSql('CREATE INDEX IDX_C3904E8ACEB712DF ON news_comment (moderator_id_id)');
        $this->addSql('CREATE INDEX IDX_C3904E8A9D86650F ON news_comment (user_id_id)');
        $this->addSql('COMMENT ON COLUMN news_comment.id IS \'(DC2Type:uuid)\'');
        $this->addSql('COMMENT ON COLUMN news_comment.news_id_id IS \'(DC2Type:uuid)\'');
        $this->addSql('COMMENT ON COLUMN news_comment.moderator_id_id IS \'(DC2Type:uuid)\'');
        $this->addSql('COMMENT ON COLUMN news_comment.user_id_id IS \'(DC2Type:uuid)\'');
        $this->addSql('COMMENT ON COLUMN news_comment.create_at IS \'(DC2Type:datetime_immutable)\'');
        $this->addSql('COMMENT ON COLUMN news_comment.update_at IS \'(DC2Type:datetime_immutable)\'');
        $this->addSql('CREATE TABLE news_type (id UUID NOT NULL, name VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('COMMENT ON COLUMN news_type.id IS \'(DC2Type:uuid)\'');
        $this->addSql('CREATE TABLE restaurant (id UUID NOT NULL, type_id_id UUID NOT NULL, settlement_id_id UUID NOT NULL, seo_id UUID NOT NULL, file_id UUID NOT NULL, name VARCHAR(255) NOT NULL, code VARCHAR(255) NOT NULL, active BOOLEAN NOT NULL, sort INT NOT NULL, create_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, update_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, coordinates TEXT NOT NULL, description TEXT NOT NULL, check_price VARCHAR(255) NOT NULL, check_info TEXT NOT NULL, phone JSON NOT NULL, email JSON NOT NULL, address JSON NOT NULL, site VARCHAR(255) NOT NULL, preview_image VARCHAR(255) NOT NULL, detail_image VARCHAR(255) NOT NULL, how_to_find TEXT NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_EB95123F714819A0 ON restaurant (type_id_id)');
        $this->addSql('CREATE INDEX IDX_EB95123F45EC589B ON restaurant (settlement_id_id)');
        $this->addSql('CREATE INDEX IDX_EB95123F97E3DD86 ON restaurant (seo_id)');
        $this->addSql('CREATE UNIQUE INDEX UNIQ_EB95123F93CB796C ON restaurant (file_id)');
        $this->addSql('COMMENT ON COLUMN restaurant.id IS \'(DC2Type:uuid)\'');
        $this->addSql('COMMENT ON COLUMN restaurant.type_id_id IS \'(DC2Type:uuid)\'');
        $this->addSql('COMMENT ON COLUMN restaurant.settlement_id_id IS \'(DC2Type:uuid)\'');
        $this->addSql('COMMENT ON COLUMN restaurant.seo_id IS \'(DC2Type:uuid)\'');
        $this->addSql('COMMENT ON COLUMN restaurant.file_id IS \'(DC2Type:uuid)\'');
        $this->addSql('COMMENT ON COLUMN restaurant.create_at IS \'(DC2Type:datetime_immutable)\'');
        $this->addSql('COMMENT ON COLUMN restaurant.update_at IS \'(DC2Type:datetime_immutable)\'');
        $this->addSql('COMMENT ON COLUMN restaurant.coordinates IS \'(DC2Type:simple_array)\'');
        $this->addSql('CREATE TABLE restaurant_type (id UUID NOT NULL, name VARCHAR(255) NOT NULL, code VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('COMMENT ON COLUMN restaurant_type.id IS \'(DC2Type:uuid)\'');
        $this->addSql('CREATE TABLE seo (id UUID NOT NULL, title VARCHAR(255) NOT NULL, description VARCHAR(255) NOT NULL, keywords VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('COMMENT ON COLUMN seo.id IS \'(DC2Type:uuid)\'');
        $this->addSql('CREATE TABLE settlement (id UUID NOT NULL, name VARCHAR(255) NOT NULL, code VARCHAR(255) NOT NULL, coordinates TEXT NOT NULL, create_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, update_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, PRIMARY KEY(id))');
        $this->addSql('COMMENT ON COLUMN settlement.id IS \'(DC2Type:uuid)\'');
        $this->addSql('COMMENT ON COLUMN settlement.coordinates IS \'(DC2Type:array)\'');
        $this->addSql('COMMENT ON COLUMN settlement.create_at IS \'(DC2Type:datetime_immutable)\'');
        $this->addSql('COMMENT ON COLUMN settlement.update_at IS \'(DC2Type:datetime_immutable)\'');
        $this->addSql('CREATE TABLE tags (id UUID NOT NULL, restaurant_id UUID NOT NULL, name VARCHAR(255) NOT NULL, list TEXT NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_6FBC9426B1E7706E ON tags (restaurant_id)');
        $this->addSql('COMMENT ON COLUMN tags.id IS \'(DC2Type:uuid)\'');
        $this->addSql('COMMENT ON COLUMN tags.restaurant_id IS \'(DC2Type:uuid)\'');
        $this->addSql('COMMENT ON COLUMN tags.list IS \'(DC2Type:simple_array)\'');
        $this->addSql('CREATE TABLE "user" (id UUID NOT NULL, name VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('COMMENT ON COLUMN "user".id IS \'(DC2Type:uuid)\'');
        $this->addSql('CREATE TABLE messenger_messages (id BIGSERIAL NOT NULL, body TEXT NOT NULL, headers TEXT NOT NULL, queue_name VARCHAR(190) NOT NULL, created_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, available_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, delivered_at TIMESTAMP(0) WITHOUT TIME ZONE DEFAULT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_75EA56E0FB7336F0 ON messenger_messages (queue_name)');
        $this->addSql('CREATE INDEX IDX_75EA56E0E3BD61CE ON messenger_messages (available_at)');
        $this->addSql('CREATE INDEX IDX_75EA56E016BA31DB ON messenger_messages (delivered_at)');
        $this->addSql('COMMENT ON COLUMN messenger_messages.created_at IS \'(DC2Type:datetime_immutable)\'');
        $this->addSql('COMMENT ON COLUMN messenger_messages.available_at IS \'(DC2Type:datetime_immutable)\'');
        $this->addSql('COMMENT ON COLUMN messenger_messages.delivered_at IS \'(DC2Type:datetime_immutable)\'');
        $this->addSql('CREATE OR REPLACE FUNCTION notify_messenger_messages() RETURNS TRIGGER AS $$
            BEGIN
                PERFORM pg_notify(\'messenger_messages\', NEW.queue_name::text);
                RETURN NEW;
            END;
        $$ LANGUAGE plpgsql;');
        $this->addSql('DROP TRIGGER IF EXISTS notify_trigger ON messenger_messages;');
        $this->addSql('CREATE TRIGGER notify_trigger AFTER INSERT OR UPDATE ON messenger_messages FOR EACH ROW EXECUTE PROCEDURE notify_messenger_messages();');
        $this->addSql('ALTER TABLE gallery ADD CONSTRAINT FK_472B783AB1E7706E FOREIGN KEY (restaurant_id) REFERENCES restaurant (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE gallery ADD CONSTRAINT FK_472B783A93CB796C FOREIGN KEY (file_id) REFERENCES file (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE kitchen ADD CONSTRAINT FK_EAA3CE34B1E7706E FOREIGN KEY (restaurant_id) REFERENCES restaurant (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE news ADD CONSTRAINT FK_1DD39950C54C8C93 FOREIGN KEY (type_id) REFERENCES news_type (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE news ADD CONSTRAINT FK_1DD3995097E3DD86 FOREIGN KEY (seo_id) REFERENCES seo (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE news ADD CONSTRAINT FK_1DD3995093CB796C FOREIGN KEY (file_id) REFERENCES file (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE news_news_category ADD CONSTRAINT FK_1A91D6D6B5A459A0 FOREIGN KEY (news_id) REFERENCES news (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE news_news_category ADD CONSTRAINT FK_1A91D6D63B732BAD FOREIGN KEY (news_category_id) REFERENCES news_category (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE news_comment ADD CONSTRAINT FK_C3904E8A5FB1909 FOREIGN KEY (news_id_id) REFERENCES news (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE news_comment ADD CONSTRAINT FK_C3904E8ACEB712DF FOREIGN KEY (moderator_id_id) REFERENCES "user" (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE news_comment ADD CONSTRAINT FK_C3904E8A9D86650F FOREIGN KEY (user_id_id) REFERENCES "user" (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE restaurant ADD CONSTRAINT FK_EB95123F714819A0 FOREIGN KEY (type_id_id) REFERENCES restaurant_type (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE restaurant ADD CONSTRAINT FK_EB95123F45EC589B FOREIGN KEY (settlement_id_id) REFERENCES settlement (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE restaurant ADD CONSTRAINT FK_EB95123F97E3DD86 FOREIGN KEY (seo_id) REFERENCES seo (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE restaurant ADD CONSTRAINT FK_EB95123F93CB796C FOREIGN KEY (file_id) REFERENCES file (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE tags ADD CONSTRAINT FK_6FBC9426B1E7706E FOREIGN KEY (restaurant_id) REFERENCES restaurant (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
    }

    public function down(Schema $schema): void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->addSql('CREATE SCHEMA public');
        $this->addSql('CREATE SEQUENCE gallery_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE seo_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('ALTER TABLE gallery DROP CONSTRAINT FK_472B783AB1E7706E');
        $this->addSql('ALTER TABLE gallery DROP CONSTRAINT FK_472B783A93CB796C');
        $this->addSql('ALTER TABLE kitchen DROP CONSTRAINT FK_EAA3CE34B1E7706E');
        $this->addSql('ALTER TABLE news DROP CONSTRAINT FK_1DD39950C54C8C93');
        $this->addSql('ALTER TABLE news DROP CONSTRAINT FK_1DD3995097E3DD86');
        $this->addSql('ALTER TABLE news DROP CONSTRAINT FK_1DD3995093CB796C');
        $this->addSql('ALTER TABLE news_news_category DROP CONSTRAINT FK_1A91D6D6B5A459A0');
        $this->addSql('ALTER TABLE news_news_category DROP CONSTRAINT FK_1A91D6D63B732BAD');
        $this->addSql('ALTER TABLE news_comment DROP CONSTRAINT FK_C3904E8A5FB1909');
        $this->addSql('ALTER TABLE news_comment DROP CONSTRAINT FK_C3904E8ACEB712DF');
        $this->addSql('ALTER TABLE news_comment DROP CONSTRAINT FK_C3904E8A9D86650F');
        $this->addSql('ALTER TABLE restaurant DROP CONSTRAINT FK_EB95123F714819A0');
        $this->addSql('ALTER TABLE restaurant DROP CONSTRAINT FK_EB95123F45EC589B');
        $this->addSql('ALTER TABLE restaurant DROP CONSTRAINT FK_EB95123F97E3DD86');
        $this->addSql('ALTER TABLE restaurant DROP CONSTRAINT FK_EB95123F93CB796C');
        $this->addSql('ALTER TABLE tags DROP CONSTRAINT FK_6FBC9426B1E7706E');
        $this->addSql('DROP TABLE file');
        $this->addSql('DROP TABLE gallery');
        $this->addSql('DROP TABLE kitchen');
        $this->addSql('DROP TABLE news');
        $this->addSql('DROP TABLE news_news_category');
        $this->addSql('DROP TABLE news_category');
        $this->addSql('DROP TABLE news_comment');
        $this->addSql('DROP TABLE news_type');
        $this->addSql('DROP TABLE restaurant');
        $this->addSql('DROP TABLE restaurant_type');
        $this->addSql('DROP TABLE seo');
        $this->addSql('DROP TABLE settlement');
        $this->addSql('DROP TABLE tags');
        $this->addSql('DROP TABLE "user"');
        $this->addSql('DROP TABLE messenger_messages');
    }
}
