<?php

namespace App\Controller;

use App\Action\Functions;
use App\Validation\{ArrayValidation, DateValidation};
use DateTimeImmutable;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Attribute\Route;

class HomeController extends AbstractController
{
    private Functions $functions;

    public function __construct(Functions $functions)
    {
        $this->functions = $functions;
    }

    #[Route('/func1', name: 'home', methods: ['POST'])]
    public function func1(Request $request): Response
    {
        $array = $request->get('arr');
        if (!ArrayValidation::validateFunc1($array)) {
            return new Response("Invalid array");
        }
        $array = $this->functions->sortPrice($array);
        return $this->json($array);
    }

    #[Route('/func2', name: 'func2', methods: ['POST'])]
    public function func2(Request $request): Response
    {
        $id = $request->query->getInt('id');
        $array = $request->get('arr');
        if (!ArrayValidation::validateFunc2($array)) {
            return new Response("Invalid array");
        }
        $result = $this->functions->search($array, $id);
        return $this->json($result);
    }

    #[Route('/func3', name: 'func3', methods: ['POST'])]
    public function home(Request $request): Response
    {
        $array = $request->get('arr');
        $result = $this->functions->uniqElements($array);
        return $this->json($result);
    }

    #[Route('/func4', name: 'func4', methods: ['POST'])]
    public function func4(Request $request): Response
    {
        $array = $request->get('arr');
        if (!ArrayValidation::validateFunc4($array)) {
            return new Response("Invalid array");
        }
        $result = $this->functions->prepareMenu($array);
        return $this->json($result);
    }

    #[Route('/func5/{day}/{month}/{year}', name: 'func5')]
    public function func5(int $day, int $month, int $year): Response
    {
        $dateAsString = $year . "-" . $month . "-" . $day;
        try {
            $result = $this->functions->howDaysToNy(new DateTimeImmutable($dateAsString));
        } catch (\Exception $e) {
            return new Response($e->getMessage());
        }
        return $this->json(["Days before NY:" => $result]);
    }

    #[Route('/func6/{year}', name: 'func6', methods: ['GET'])]
    public function func6(int $year): Response
    {
        $fridays = array();
        try {
            foreach ($this->functions->countFriday13($year) as $date) {
                $fridays[] = $date->format("Y-m-d l");
            }
        } catch (\Exception $e) {
            return new Response($e->getMessage());
        }
        return $this->json($fridays);
    }

    #[Route('/func7/{startDate}/{endDate}', name: 'func7')] // 01-01-2024
    public function func7(string $startDate, string $endDate): Response
    {
        if (DateValidation::validate($startDate) && DateValidation::validate($endDate)) {
            try {
                $result = $this->functions->diffDays(
                    new DateTimeImmutable($startDate),
                    new DateTimeImmutable($endDate)
                );
                return $this->json(["The difference of days:" => $result]);
            } catch (\Exception $e) {
                return new Response($e->getMessage());
            }
        }
        return new Response("Invalid date format");
    }

    #[Route('/func8/{fileName}', name: 'func8')]
    public function func8(string $fileName): Response // text.txt
    {
        $filePath = $this->getParameter('kernel.project_dir') . "/public/files/";
        $text = $this->functions->readLogFile($filePath . $fileName);
        $response = new JsonResponse($text);
        $response->setEncodingOptions(JSON_UNESCAPED_UNICODE);
        return $response;
    }
}
