<?php

namespace App\Controller;

use App\Action\Functions;
use App\Requests\{
    SortPriceRequest,
    SearchRequest,
    UniqElementsRequest,
    MenuRequest,
    HowDaysToNyRequest
};
use DateTimeImmutable;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

class HomeController extends AbstractController
{
    public function __construct(private Functions $functions) {}

    #[Route('/sortPrice', name: 'sortPrice', methods: ['POST'])]
    public function sortPrice(SortPriceRequest $request): Response
    {
        $array = $this->functions->sortPrice($request->getRequest()->toArray()['items']);
        return $this->json($array);
    }

    #[Route('/search', name: 'search', methods: ['POST'])]
    public function search(SearchRequest $request): Response
    {
        $requestData = $request->getRequest()->toArray();
        $id = $request->getRequest()->get('id');
        $result = $this->functions->search($requestData['items'], $id);
        return $this->json($result);
    }

    #[Route('/uniqElements', name: 'uniqElements', methods: ['POST'])]
    public function uniqElements(UniqElementsRequest $request): Response
    {
        $result = $this->functions->uniqElements($request->getRequest()->toArray()['items']);
        return $this->json($result);
    }

    #[Route('/prepareMenu', name: 'prepareMenu', methods: ['POST'])]
    public function prepareMenu(MenuRequest $request): Response
    {
        $result = $this->functions->prepareMenu($request->getRequest()->toArray()['items']);
        return $this->json($result);
    }

    #[Route('/howDaysToNy', name: 'howDaysToNy', methods: ['GET'])]
    public function howDaysToNy(HowDaysToNyRequest $request): Response
    {
        $date = $request->getRequest()->get('date');
        try {
            $result = $this->functions->howDaysToNy(new DateTimeImmutable($date));
        } catch (\Exception $e) {
            return new Response($e->getMessage());
        }
        return $this->json(["Days before NY:" => $result]);
    }
}
