<?php

declare(strict_types=1);

namespace App\Action;

class Functions
{
    /**
     * Выполняет сортировку массива по убыванию цены
     * @param array $array
     * @return array
     */
    public function sortPrice(array $array): array
    {
        $prices = array_column($array, 'price');
        $counts = array_column($array, 'count');
        array_multisort(
            $prices,
            SORT_DESC,
            $counts,
            SORT_ASC, $array
        );
        return $array;
    }

    /**
     * Найдет элемент с указаным id
     * @param array $array - массив, содержащий элементы со структурой
     * [
     *  'id' => 30,
     *  'name' => 'Jhon',
     *  'age' => 23,
     * ]
     * @param $id - ид искомого элемента
     * @return ?array - найденный элемент
     */

    public function search(array $array, int $id): ?array
    {
        $rowId = array_search($id, array_column($array, 'id'), false);
        if ($rowId !== false) {
            return $array[$rowId];
        }
        return null;
    }

    /**
     * Удалить дубликаты, оставив только уникальные значения
     * @param array $array
     * @return array
     */
    public function uniqElements(array $array): array
    {
        return array_unique($array, SORT_REGULAR);
    }

    /**
     * Сгруппировать подразедлы в верхние разделы меню
     * Дочерние элементы поместить в массив родителя с ключом submenu
     * Значение под ключом depth определяет уровень раздела
     * Массив $aMenu всегда начинается с элемента depth = 0,
     * все последующие элементы с depth = 1 являются его дочерними
     * элементами
     * @param array $aMenu
     * @return array
     */
    public function prepareMenu(array $aMenu): array
    {
        $result = [];
        foreach ($aMenu as $arr) {
            if ($arr['depth'] == 0) {
                $result[] = array(
                    'name' => $arr['name'],
                    'depth' => $arr['depth'],
                    'submenu' => []
                );
                continue;
            }
            $result[array_key_last($result)]['submenu'][] = array(
                'name' => $arr['name'],
                'depth' => $arr['depth'],
            );
        }
        return $result;
    }
}