<?php

namespace App\Controller;

use App\Action\Functions;
use App\Requests\{
    SortPriceRequest,
    SearchRequest,
    UniqElementsRequest
};
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

class HomeController extends AbstractController
{
    public function __construct(private Functions $functions) {}

    #[Route('/sortPrice', name: 'sortPrice', methods: ['POST'])]
    public function sortPrice(SortPriceRequest $request): Response
    {
        $array = $this->functions->sortPrice($request->getRequest()->toArray()['items']);
        return $this->json($array);
    }

    #[Route('/search', name: 'search', methods: ['POST'])]
    public function search(SearchRequest $request): Response
    {
        $array = $request->getRequest()->toArray()['items'];
        $id = $request->getRequest()->query->get('id');
        $result = $this->functions->search($array, $id);
        return $this->json($result);
    }

    #[Route('/uniqElements', name: 'uniqElements', methods: ['POST'])]
    public function uniqElements(UniqElementsRequest $request): Response
    {
        $result = $this->functions->uniqElements($request->getRequest()->toArray()['items']);
        return $this->json($result);
    }
}
