<?php

declare(strict_types=1);

namespace App\Action;

class Functions
{
    /**
     * Выполняет сортировку массива по убыванию цены
     * @param array $array
     * @return array
     */
    public function sortPrice(array $array): array
    {
        $prices = array_column($array, 'price');
        $counts = array_column($array, 'count');
        array_multisort(
            $prices,
            SORT_DESC,
            $counts,
            SORT_ASC, $array
        );
        return $array;
    }
}