<?php

namespace App\Repository;

use App\Exception\NewsExceptionEnum;
use Exception;
use App\Entity\News;
use App\Repository\Interface\NewsRepositoryInterface;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<News>
 *
 * @method News|null find($id, $lockMode = null, $lockVersion = null)
 * @method News|null findOneBy(array $criteria, array $orderBy = null)
 * @method News[]    findAll()
 * @method News[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class NewsRepository extends ServiceEntityRepository implements NewsRepositoryInterface
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, News::class);
    }

    public function getAll($page, $limit, $newsCategory): array
    {
        $query = $this->getEntityManager()->createQueryBuilder();
        $query->select('n')->from(News::class, 'n');
        if ($newsCategory !== null) {
            $query->join('n.newsCategories', 'nc')
                ->andWhere('nc.id = :newsCategory')
                ->setParameter('newsCategory', $newsCategory);
        }
        $query->setMaxResults($limit)
            ->setFirstResult(($page - 1) * $limit);
        return $query->getQuery()->getResult();
    }

    public function getCount(): int
    {
        return $this->count();
    }

    public function getMainNews(): News
    {
        return $this->findOneBy(['mainPageRender' => true]);
    }

    public function getNewsById(string $newsId): News|null
    {
        try {
            return $this->find(['id' => $newsId]);
        } catch (Exception $e) {
            throw new Exception("News not found", NewsExceptionEnum::NotFound->value);
        }
    }
}
