<?php

namespace App\Mapper;

use App\Entity\News;
use App\Entity\NewsCategory;
use App\Model\File;
use App\Model\NewsDetailElement;
use App\Model\NewsFilterVariants;
use App\Model\NewsList;
use App\Model\NewsListingElement;
use App\Model\NewsCategory as NewsCategoryModel;
use App\Model\Pagination;
use Ramsey\Collection\Collection;

class NewsMapper
{
    public static function mapToNewsList(
        $news,
        $newsCategory,
        $page,
        $limit,
        $count): NewsList
    {
        return new NewsList(
            new Pagination($page, ceil($count / $limit), $limit),
            new Collection(NewsListingElement::class, array_map(
                function (News $newsOne) {
                    return self::mapToListingElement($newsOne);
                }, $news)
            ),
            new NewsFilterVariants(
                new Collection(NewsCategoryModel::class, array_map(
                    function (NewsCategory $newsCategoryOne) {
                        return self::mapToNewsCategory($newsCategoryOne);
                    }, $newsCategory)
                )
            )
        );
    }

    public static function mapToListingElement(News $newsOne): NewsListingElement
    {
        $file = new File(
            1,
            "asd",
            "Краткое описание",
            1024,
            "png",
            "/upload/asd.png"
        );
        return new NewsListingElement(
            $newsOne->getId(),
            $newsOne->getPreviewText(),
            $newsOne->getDetailText(),
            $file,
            $newsOne->getCreateAt()->format('d.m.Y'),
            "/{$newsOne->getCode()}/code/"
        );
    }

    public static function mapToDetailElement(News $newsOne): NewsDetailElement
    {
        $file = new File(
            1,
            "asd",
            "Краткое описание",
            1024,
            "png",
            "/upload/asd.png"
        );
        return new NewsDetailElement(
            $newsOne->getId(),
            $newsOne->getPreviewText(),
            $newsOne->getDetailText(),
            $newsOne->getDetailText(),
            $file,
            $newsOne->getCreateAt()->format('d.m.Y'),
            "Отель «Арктика»",
            "otel-arktika",
            "otel-arktika"
        );
    }

    public static function mapToNewsCategory(NewsCategory $newsCategory): NewsCategoryModel
    {
        return new NewsCategoryModel(
            $newsCategory->getId(),
            $newsCategory->getName(),
            $newsCategory->getCode(),
        );
    }
}