<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20240426064235 extends AbstractMigration
{
    public function getDescription(): string
    {
        return '';
    }

    public function up(Schema $schema): void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->addSql('CREATE SEQUENCE address_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE email_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE kitchen_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE news_comment_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE news_type_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE phone_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE restaurant_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE restaurant_type_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE settlement_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE tags_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE "user_id_seq" INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE TABLE address (id INT NOT NULL, restaurant_id INT NOT NULL, name VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_D4E6F81B1E7706E ON address (restaurant_id)');
        $this->addSql('CREATE TABLE email (id INT NOT NULL, restaurant_id INT NOT NULL, name VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_E7927C74B1E7706E ON email (restaurant_id)');
        $this->addSql('CREATE TABLE kitchen (id INT NOT NULL, restaurant_id INT NOT NULL, name VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_EAA3CE34B1E7706E ON kitchen (restaurant_id)');
        $this->addSql('CREATE TABLE news (id UUID NOT NULL, type_id INT NOT NULL, code VARCHAR(255) NOT NULL, active BOOLEAN NOT NULL, create_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, update_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, sort INT NOT NULL, preview_image VARCHAR(255) NOT NULL, detail_image VARCHAR(255) NOT NULL, preview_text TEXT NOT NULL, detail_text TEXT NOT NULL, main_page_render BOOLEAN NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_1DD39950C54C8C93 ON news (type_id)');
        $this->addSql('COMMENT ON COLUMN news.id IS \'(DC2Type:uuid)\'');
        $this->addSql('CREATE TABLE news_news_category (news_id UUID NOT NULL, news_category_id UUID NOT NULL, PRIMARY KEY(news_id, news_category_id))');
        $this->addSql('CREATE INDEX IDX_1A91D6D6B5A459A0 ON news_news_category (news_id)');
        $this->addSql('CREATE INDEX IDX_1A91D6D63B732BAD ON news_news_category (news_category_id)');
        $this->addSql('COMMENT ON COLUMN news_news_category.news_id IS \'(DC2Type:uuid)\'');
        $this->addSql('COMMENT ON COLUMN news_news_category.news_category_id IS \'(DC2Type:uuid)\'');
        $this->addSql('CREATE TABLE news_category (id UUID NOT NULL, name VARCHAR(255) NOT NULL, code VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('COMMENT ON COLUMN news_category.id IS \'(DC2Type:uuid)\'');
        $this->addSql('CREATE TABLE news_comment (id INT NOT NULL, news_id_id UUID NOT NULL, moderator_id_id INT NOT NULL, user_id_id INT NOT NULL, moderated BOOLEAN NOT NULL, user_name VARCHAR(255) NOT NULL, text VARCHAR(255) NOT NULL, create_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, update_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE UNIQUE INDEX UNIQ_C3904E8A5FB1909 ON news_comment (news_id_id)');
        $this->addSql('CREATE INDEX IDX_C3904E8ACEB712DF ON news_comment (moderator_id_id)');
        $this->addSql('CREATE INDEX IDX_C3904E8A9D86650F ON news_comment (user_id_id)');
        $this->addSql('COMMENT ON COLUMN news_comment.news_id_id IS \'(DC2Type:uuid)\'');
        $this->addSql('CREATE TABLE news_type (id INT NOT NULL, name VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE TABLE phone (id INT NOT NULL, restaurant_id INT NOT NULL, name VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_444F97DDB1E7706E ON phone (restaurant_id)');
        $this->addSql('CREATE TABLE restaurant (id INT NOT NULL, type_id_id INT NOT NULL, settlement_id_id INT NOT NULL, uuid UUID NOT NULL, name VARCHAR(255) NOT NULL, code VARCHAR(255) NOT NULL, active BOOLEAN NOT NULL, sort INT NOT NULL, create_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, update_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, coordinates TEXT NOT NULL, description TEXT NOT NULL, check_price VARCHAR(255) NOT NULL, check_info TEXT NOT NULL, site VARCHAR(255) NOT NULL, preview_image VARCHAR(255) NOT NULL, detail_image VARCHAR(255) NOT NULL, how_to_find TEXT NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE UNIQUE INDEX UNIQ_EB95123FD17F50A6 ON restaurant (uuid)');
        $this->addSql('CREATE INDEX IDX_EB95123F714819A0 ON restaurant (type_id_id)');
        $this->addSql('CREATE INDEX IDX_EB95123F45EC589B ON restaurant (settlement_id_id)');
        $this->addSql('COMMENT ON COLUMN restaurant.uuid IS \'(DC2Type:uuid)\'');
        $this->addSql('COMMENT ON COLUMN restaurant.coordinates IS \'(DC2Type:array)\'');
        $this->addSql('CREATE TABLE restaurant_type (id INT NOT NULL, name VARCHAR(255) NOT NULL, code VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE TABLE settlement (id INT NOT NULL, uuid UUID NOT NULL, name VARCHAR(255) NOT NULL, code VARCHAR(255) NOT NULL, coordinates TEXT NOT NULL, create_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, update_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE UNIQUE INDEX UNIQ_DD9F1B51D17F50A6 ON settlement (uuid)');
        $this->addSql('COMMENT ON COLUMN settlement.uuid IS \'(DC2Type:uuid)\'');
        $this->addSql('COMMENT ON COLUMN settlement.coordinates IS \'(DC2Type:array)\'');
        $this->addSql('CREATE TABLE tags (id INT NOT NULL, restaurant_id INT NOT NULL, name VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_6FBC9426B1E7706E ON tags (restaurant_id)');
        $this->addSql('CREATE TABLE "user" (id INT NOT NULL, uuid UUID NOT NULL, name VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE UNIQUE INDEX UNIQ_8D93D649D17F50A6 ON "user" (uuid)');
        $this->addSql('COMMENT ON COLUMN "user".uuid IS \'(DC2Type:uuid)\'');
        $this->addSql('CREATE TABLE messenger_messages (id BIGSERIAL NOT NULL, body TEXT NOT NULL, headers TEXT NOT NULL, queue_name VARCHAR(190) NOT NULL, created_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, available_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, delivered_at TIMESTAMP(0) WITHOUT TIME ZONE DEFAULT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_75EA56E0FB7336F0 ON messenger_messages (queue_name)');
        $this->addSql('CREATE INDEX IDX_75EA56E0E3BD61CE ON messenger_messages (available_at)');
        $this->addSql('CREATE INDEX IDX_75EA56E016BA31DB ON messenger_messages (delivered_at)');
        $this->addSql('COMMENT ON COLUMN messenger_messages.created_at IS \'(DC2Type:datetime_immutable)\'');
        $this->addSql('COMMENT ON COLUMN messenger_messages.available_at IS \'(DC2Type:datetime_immutable)\'');
        $this->addSql('COMMENT ON COLUMN messenger_messages.delivered_at IS \'(DC2Type:datetime_immutable)\'');
        $this->addSql('CREATE OR REPLACE FUNCTION notify_messenger_messages() RETURNS TRIGGER AS $$
            BEGIN
                PERFORM pg_notify(\'messenger_messages\', NEW.queue_name::text);
                RETURN NEW;
            END;
        $$ LANGUAGE plpgsql;');
        $this->addSql('DROP TRIGGER IF EXISTS notify_trigger ON messenger_messages;');
        $this->addSql('CREATE TRIGGER notify_trigger AFTER INSERT OR UPDATE ON messenger_messages FOR EACH ROW EXECUTE PROCEDURE notify_messenger_messages();');
        $this->addSql('ALTER TABLE address ADD CONSTRAINT FK_D4E6F81B1E7706E FOREIGN KEY (restaurant_id) REFERENCES restaurant (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE email ADD CONSTRAINT FK_E7927C74B1E7706E FOREIGN KEY (restaurant_id) REFERENCES restaurant (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE kitchen ADD CONSTRAINT FK_EAA3CE34B1E7706E FOREIGN KEY (restaurant_id) REFERENCES restaurant (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE news ADD CONSTRAINT FK_1DD39950C54C8C93 FOREIGN KEY (type_id) REFERENCES news_type (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE news_news_category ADD CONSTRAINT FK_1A91D6D6B5A459A0 FOREIGN KEY (news_id) REFERENCES news (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE news_news_category ADD CONSTRAINT FK_1A91D6D63B732BAD FOREIGN KEY (news_category_id) REFERENCES news_category (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE news_comment ADD CONSTRAINT FK_C3904E8A5FB1909 FOREIGN KEY (news_id_id) REFERENCES news (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE news_comment ADD CONSTRAINT FK_C3904E8ACEB712DF FOREIGN KEY (moderator_id_id) REFERENCES "user" (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE news_comment ADD CONSTRAINT FK_C3904E8A9D86650F FOREIGN KEY (user_id_id) REFERENCES "user" (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE phone ADD CONSTRAINT FK_444F97DDB1E7706E FOREIGN KEY (restaurant_id) REFERENCES restaurant (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE restaurant ADD CONSTRAINT FK_EB95123F714819A0 FOREIGN KEY (type_id_id) REFERENCES restaurant_type (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE restaurant ADD CONSTRAINT FK_EB95123F45EC589B FOREIGN KEY (settlement_id_id) REFERENCES settlement (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE tags ADD CONSTRAINT FK_6FBC9426B1E7706E FOREIGN KEY (restaurant_id) REFERENCES restaurant (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
    }

    public function down(Schema $schema): void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->addSql('CREATE SCHEMA public');
        $this->addSql('DROP SEQUENCE address_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE email_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE kitchen_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE news_comment_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE news_type_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE phone_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE restaurant_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE restaurant_type_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE settlement_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE tags_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE "user_id_seq" CASCADE');
        $this->addSql('ALTER TABLE address DROP CONSTRAINT FK_D4E6F81B1E7706E');
        $this->addSql('ALTER TABLE email DROP CONSTRAINT FK_E7927C74B1E7706E');
        $this->addSql('ALTER TABLE kitchen DROP CONSTRAINT FK_EAA3CE34B1E7706E');
        $this->addSql('ALTER TABLE news DROP CONSTRAINT FK_1DD39950C54C8C93');
        $this->addSql('ALTER TABLE news_news_category DROP CONSTRAINT FK_1A91D6D6B5A459A0');
        $this->addSql('ALTER TABLE news_news_category DROP CONSTRAINT FK_1A91D6D63B732BAD');
        $this->addSql('ALTER TABLE news_comment DROP CONSTRAINT FK_C3904E8A5FB1909');
        $this->addSql('ALTER TABLE news_comment DROP CONSTRAINT FK_C3904E8ACEB712DF');
        $this->addSql('ALTER TABLE news_comment DROP CONSTRAINT FK_C3904E8A9D86650F');
        $this->addSql('ALTER TABLE phone DROP CONSTRAINT FK_444F97DDB1E7706E');
        $this->addSql('ALTER TABLE restaurant DROP CONSTRAINT FK_EB95123F714819A0');
        $this->addSql('ALTER TABLE restaurant DROP CONSTRAINT FK_EB95123F45EC589B');
        $this->addSql('ALTER TABLE tags DROP CONSTRAINT FK_6FBC9426B1E7706E');
        $this->addSql('DROP TABLE address');
        $this->addSql('DROP TABLE email');
        $this->addSql('DROP TABLE kitchen');
        $this->addSql('DROP TABLE news');
        $this->addSql('DROP TABLE news_news_category');
        $this->addSql('DROP TABLE news_category');
        $this->addSql('DROP TABLE news_comment');
        $this->addSql('DROP TABLE news_type');
        $this->addSql('DROP TABLE phone');
        $this->addSql('DROP TABLE restaurant');
        $this->addSql('DROP TABLE restaurant_type');
        $this->addSql('DROP TABLE settlement');
        $this->addSql('DROP TABLE tags');
        $this->addSql('DROP TABLE "user"');
        $this->addSql('DROP TABLE messenger_messages');
    }
}
