<?php

declare(strict_types=1);

namespace App\Tests;

use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

class RestaurantControllerTest extends WebTestCase
{
    private const RESTAURANT_ID = '018f3d5b-6688-7a34-b4ee-415cc851d5fa';
    private const RESTAURANT_TYPE_ID = '018f3d5b-6688-7a34-b4ee-415cc59ae55a';

    public function testRestaurantsSuccessResponse(): void
    {
        $client = static::createClient();
        $crawler = $client->request(
            'GET',
            '/api/v1/restaurants?page=1&limit=12'
        );

        $this->assertResponseIsSuccessful();
    }

    public function testRestaurantsSuccessResponseWithoutQuery(): void
    {
        $client = static::createClient();
        $crawler = $client->request(
            'GET',
            '/api/v1/restaurants'
        );

        $this->assertResponseIsSuccessful();
    }

    public function testRestaurantsJsonDataPartly(): void
    {
        $client = static::createClient();
        $crawler = $client->request(
            'GET',
            '/api/v1/restaurants'
        );
        $data = $client->getResponse()->getContent();

        $this->assertStringContainsString('image' , $data);
    }

    public function testRestaurantsJsonData(): void
    {
        $client = static::createClient();
        $crawler = $client->request(
            'GET',
            '/api/v1/restaurants?page=1&limit=12'
        );
        $data = $client->getResponse()->getContent();
        $expected = file_get_contents(__DIR__ . '/responses/restaurants.json');

        $this->assertJsonStringEqualsJsonString($expected, $data);
    }

    public function testRestaurantsWithTypeId(): void
    {
        $client = static::createClient();
        $crawler = $client->request(
            'GET',
            '/api/v1/restaurants?page=1&limit=12&restaurant_type_id='
            . self::RESTAURANT_TYPE_ID
        );
        $data = $client->getResponse()->getContent();
        $expected = file_get_contents(__DIR__ . '/responses/restaurants.json');

        $this->assertJsonStringEqualsJsonString($expected, $data);
    }

    public function testRestaurantSuccessResponse(): void
    {
        $client = static::createClient();
        $crawler = $client->request(
            'GET',
            '/api/v1/restaurants/' . self::RESTAURANT_ID
        );

        $this->assertResponseIsSuccessful();
    }

    public function testRestaurantJsonDataPartly(): void
    {
        $client = static::createClient();
        $crawler = $client->request(
            'GET',
            '/api/v1/restaurants/' . self::RESTAURANT_ID
        );
        $data = $client->getResponse()->getContent();

        $this->assertStringContainsString('tags' , $data);
    }

    public function testRestaurantJsonData(): void
    {
        $client = static::createClient();
        $crawler = $client->request(
            'GET',
            '/api/v1/restaurants/' . self::RESTAURANT_ID
        );
        $data = $client->getResponse()->getContent();
        $expected = file_get_contents(__DIR__ . '/responses/restaurant.json');

        $this->assertJsonStringEqualsJsonString($expected, $data);
    }

    public function testRestaurantNotFound(): void
    {
        $client = static::createClient();
        $crawler = $client->request(
            'GET',
            '/api/v1/restaurants/test'
        );

        $data = $client->getResponse()->getContent();
        $expected = file_get_contents(__DIR__ . '/responses/restaurantNotFound.json');

        $this->assertJsonStringEqualsJsonString($expected, $data);
    }
}
