<?php

namespace App\Tests;

use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

class NewsControllerTest extends WebTestCase
{
    private const NEWS_ID = '018f3d5b-65c7-7998-a6d5-2270db52f830';
    private const NEWS_CATEGORY_ID = '018f3d5b-65c7-7998-a6d5-2270da54ce3c';

    public function testNewsSuccessResponse(): void
    {
        $client = static::createClient();
        $crawler = $client->request(
            'GET',
            '/api/v1/news?page=1&limit=12'
        );

        $this->assertResponseIsSuccessful();
    }

    public function testNewsJsonDataPartly(): void
    {
        $client = static::createClient();
        $crawler = $client->request(
            'GET',
            '/api/v1/news'
        );
        $data = $client->getResponse()->getContent();

        $this->assertStringContainsString('url' , $data);
    }

    public function testNewsJsonData(): void
    {
        $client = static::createClient();
        $crawler = $client->request(
            'GET',
            '/api/v1/news?page=1&limit=12'
        );
        $data = $client->getResponse()->getContent();
        $expected = file_get_contents(__DIR__ . '/responses/news.json');

        $this->assertJsonStringEqualsJsonString($expected, $data);
    }

    public function testNewsWithNewsCategory(): void
    {
        $client = static::createClient();
        $crawler = $client->request(
            'GET',
            '/api/v1/news?page=1&limit=12&news_category_id=' . self::NEWS_CATEGORY_ID
        );
        $data = $client->getResponse()->getContent();
        $expected = file_get_contents(__DIR__ . '/responses/news.json');

        $this->assertJsonStringEqualsJsonString($expected, $data);
    }

    public function testMainNewsJsonDataPartly(): void
    {
        $client = static::createClient();
        $crawler = $client->request(
            'GET',
            '/api/v1/news/mainNews'
        );
        $data = $client->getResponse()->getContent();

        $this->assertStringContainsString('name' , $data);
    }

    public function testMainNews(): void
    {
        $client = static::createClient();
        $crawler = $client->request(
            'GET',
            '/api/v1/news/mainNews'
        );
        $data = $client->getResponse()->getContent();
        $expected = file_get_contents(__DIR__ . '/responses/mainNews.json');

        $this->assertJsonStringEqualsJsonString($expected, $data);
    }

    public function testSearchNewsJsonDataPartly(): void
    {
        $client = static::createClient();
        $crawler = $client->request(
            'GET',
            '/api/v1/news/search'
        );
        $data = $client->getResponse()->getContent();

        $this->assertStringContainsString('seoTitle' , $data);
    }

    public function testSearchNews(): void
    {
        $client = static::createClient();
        $crawler = $client->request(
            'GET',
            '/api/v1/news/search'
        );
        $data = $client->getResponse()->getContent();
        $expected = file_get_contents(__DIR__ . '/responses/searchNews.json');

        $this->assertJsonStringEqualsJsonString($expected, $data);
    }

    public function testNewsOne(): void
    {
        $client = static::createClient();
        $crawler = $client->request(
            'GET',
            '/api/v1/news/' . self::NEWS_ID
        );
        $data = $client->getResponse()->getContent();
        $expected = file_get_contents(__DIR__ . '/responses/searchNews.json');

        $this->assertJsonStringEqualsJsonString($expected, $data);
    }

    public function testNewsOneJsonDataPartly(): void
    {
        $client = static::createClient();
        $crawler = $client->request(
            'GET',
            '/api/v1/news/' . self::NEWS_ID
        );
        $data = $client->getResponse()->getContent();

        $this->assertStringContainsString('createAt' , $data);
    }

    public function testNewsOneNotFound(): void
    {
        $client = static::createClient();
        $crawler = $client->request(
            'GET',
            '/api/v1/news/test'
        );
        $data = $client->getResponse()->getContent();
        $expected = file_get_contents(__DIR__ . '/responses/newsNotFound.json');

        $this->assertJsonStringEqualsJsonString($expected, $data);
    }
}