<?php

namespace App\Requests;

use Symfony\Component\Validator\Constraints as Assert;

class RestaurantListRequest extends BaseRequest
{
    #[Assert\Type('int')]
    public $page;
    #[Assert\Type('int')]
    public $limit;
    #[Assert\Uuid]
    public $restaurant_type_id;
    #[Assert\Uuid]
    public $kitchen_id;

    protected function populate(): void
    {
        foreach ($this->getRequest()->query as $property => $value) {
            if (property_exists($this, $property)) {
                $this->{$property} = ctype_digit($value) ? (int)$value : $value;
            }
        }
    }
}