<?php

namespace App\Requests;

use Symfony\Component\Form\Extension\Core\Type\UuidType;
use Symfony\Component\Uid\UuidV4;
use Symfony\Component\Validator\Constraints as Assert;

class NewsListRequest extends BaseRequest
{
    #[Assert\Type('int')]
    public $page;
    #[Assert\Type('int')]
    public $limit;
    #[Assert\Uuid]
    public $news_category;

    protected function populate(): void
    {
        foreach ($this->getRequest()->query as $property => $value) {
            if (property_exists($this, $property)) {
                $this->{$property} = ctype_digit($value) ? (int)$value : $value;
            }
        }
    }
}