<?php

namespace App\Requests;

use Symfony\Component\Uid\Uuid;
use Symfony\Component\Validator\Constraints as Assert;

class EditNewsRequest
{
    #[Assert\NotBlank]
    #[Assert\Uuid]
    private Uuid $typeId;

    #[Assert\NotBlank]
    #[Assert\Uuid]
    private Uuid $seoId;

    #[Assert\NotBlank]
    #[Assert\Uuid]
    private Uuid $fileId;

    #[Assert\NotBlank]
    private string $code;

    #[Assert\NotBlank]
    #[Assert\Type('bool')]
    private bool $active;

    #[Assert\NotBlank]
    #[Assert\Type('int')]
    private int $sort;

    private string $previewImage;

    private string $detailImage;

    private string $previewText;

    private string $detailText;

    #[Assert\Type('bool')]
    private bool $mainPageRender;

    public function getTypeId(): Uuid
    {
        return $this->typeId;
    }

    public function setTypeId(Uuid $typeId): self
    {
        $this->typeId = $typeId;
        return $this;
    }

    public function getSeoId(): Uuid
    {
        return $this->seoId;
    }

    public function setSeoId(Uuid $seoId): self
    {
        $this->seoId = $seoId;
        return $this;
    }

    public function getFileId(): Uuid
    {
        return $this->fileId;
    }

    public function setFileId(Uuid $fileId): self
    {
        $this->fileId = $fileId;
        return $this;
    }

    public function getCode(): string
    {
        return $this->code;
    }

    public function setCode(string $code): self
    {
        $this->code = $code;
        return $this;
    }

    public function isActive(): bool
    {
        return $this->active;
    }

    public function setActive(bool $active): self
    {
        $this->active = $active;
        return $this;
    }

    public function getSort(): int
    {
        return $this->sort;
    }

    public function setSort(int $sort): self
    {
        $this->sort = $sort;
        return $this;
    }

    public function getPreviewImage(): string
    {
        return $this->previewImage;
    }

    public function setPreviewImage(string $previewImage): self
    {
        $this->previewImage = $previewImage;
        return $this;
    }

    public function getDetailImage(): string
    {
        return $this->detailImage;
    }

    public function setDetailImage(string $detailImage): self
    {
        $this->detailImage = $detailImage;
        return $this;
    }

    public function getPreviewText(): string
    {
        return $this->previewText;
    }

    public function setPreviewText(string $previewText): self
    {
        $this->previewText = $previewText;
        return $this;
    }

    public function getDetailText(): string
    {
        return $this->detailText;
    }

    public function setDetailText(string $detailText): self
    {
        $this->detailText = $detailText;
        return $this;
    }

    public function isMainPageRender(): bool
    {
        return $this->mainPageRender;
    }

    public function setMainPageRender(bool $mainPageRender): self
    {
        $this->mainPageRender = $mainPageRender;
        return $this;
    }
}