<?php

namespace App\Requests;

use Symfony\Component\Uid\Uuid;
use Symfony\Component\Validator\Constraints as Assert;

class CreateRestaurantRequest
{
    #[Assert\NotBlank]
    #[Assert\Uuid]
    private Uuid $typeId;

    #[Assert\NotBlank]
    #[Assert\Uuid]
    private Uuid $settlementId;

    #[Assert\NotBlank]
    #[Assert\Uuid]
    private Uuid $seoId;

    #[Assert\NotBlank]
    #[Assert\Uuid]
    private Uuid $fileId;

    #[Assert\NotBlank]
    private string $name;

    #[Assert\NotBlank]
    private string $code;

    #[Assert\Type('bool')]
    private bool $active;

    #[Assert\Type('int')]
    private int $sort;

    #[Assert\Type('array')]
    private array $coordinates;

    private string $description;

    private string $check;

    private string $checkInfo;

    #[Assert\Type('array')]
    private array $phone;

    #[Assert\Type('array')]
    private array $email;

    #[Assert\Type('array')]
    private array $address;

    private string $site;

    private string $previewImage;

    private string $detailImage;

    private string $howToFind;

    public function getTypeId(): Uuid
    {
        return $this->typeId;
    }

    public function setTypeId(Uuid $typeId): self
    {
        $this->typeId = $typeId;
        return $this;
    }

    public function getSettlementId(): Uuid
    {
        return $this->settlementId;
    }

    public function setSettlementId(Uuid $settlementId): self
    {
        $this->settlementId = $settlementId;
        return $this;
    }

    public function getSeoId(): Uuid
    {
        return $this->seoId;
    }

    public function setSeoId(Uuid $seoId): self
    {
        $this->seoId = $seoId;
        return $this;
    }

    public function getFileId(): Uuid
    {
        return $this->fileId;
    }

    public function setFileId(Uuid $fileId): self
    {
        $this->fileId = $fileId;
        return $this;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->name = $name;
        return $this;
    }

    public function getCode(): string
    {
        return $this->code;
    }

    public function setCode(string $code): self
    {
        $this->code = $code;
        return $this;
    }

    public function isActive(): bool
    {
        return $this->active;
    }

    public function setActive(bool $active): self
    {
        $this->active = $active;
        return $this;
    }

    public function getSort(): int
    {
        return $this->sort;
    }

    public function setSort(int $sort): self
    {
        $this->sort = $sort;
        return $this;
    }

    public function getCoordinates(): array
    {
        return $this->coordinates;
    }

    public function setCoordinates(array $coordinates): self
    {
        $this->coordinates = $coordinates;
        return $this;
    }

    public function getDescription(): string
    {
        return $this->description;
    }

    public function setDescription(string $description): self
    {
        $this->description = $description;
        return $this;
    }

    public function getCheck(): string
    {
        return $this->check;
    }

    public function setCheck(string $check): self
    {
        $this->check = $check;
        return $this;
    }

    public function getCheckInfo(): string
    {
        return $this->checkInfo;
    }

    public function setCheckInfo(string $checkInfo): self
    {
        $this->checkInfo = $checkInfo;
        return $this;
    }

    public function getPhone(): array
    {
        return $this->phone;
    }

    public function setPhone(array $phone): self
    {
        $this->phone = $phone;
        return $this;
    }

    public function getEmail(): array
    {
        return $this->email;
    }

    public function setEmail(array $email): self
    {
        $this->email = $email;
        return $this;
    }

    public function getAddress(): array
    {
        return $this->address;
    }

    public function setAddress(array $address): self
    {
        $this->address = $address;
        return $this;
    }

    public function getSite(): string
    {
        return $this->site;
    }

    public function setSite(string $site): self
    {
        $this->site = $site;
        return $this;
    }

    public function getPreviewImage(): string
    {
        return $this->previewImage;
    }

    public function setPreviewImage(string $previewImage): self
    {
        $this->previewImage = $previewImage;
        return $this;
    }

    public function getDetailImage(): string
    {
        return $this->detailImage;
    }

    public function setDetailImage(string $detailImage): self
    {
        $this->detailImage = $detailImage;
        return $this;
    }

    public function getHowToFind(): string
    {
        return $this->howToFind;
    }

    public function setHowToFind(string $howToFind): self
    {
        $this->howToFind = $howToFind;
        return $this;
    }
}