<?php

namespace App\Repository;

use App\Entity\RestaurantType;
use App\Repository\Interface\RestaurantTypeRepositoryInterface;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\Uid\Uuid;

/**
 * @extends ServiceEntityRepository<RestaurantType>
 *
 * @method RestaurantType|null find($id, $lockMode = null, $lockVersion = null)
 * @method RestaurantType|null findOneBy(array $criteria, array $orderBy = null)
 * @method RestaurantType[]    findAll()
 * @method RestaurantType[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class RestaurantTypeRepository extends ServiceEntityRepository implements RestaurantTypeRepositoryInterface
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, RestaurantType::class);
    }

    public function getAll(): array
    {
        return $this->findAll();
    }

    public function getById(Uuid $id): ?RestaurantType
    {
        return $this->find($id);
    }
}
