<?php

namespace App\Repository;

use App\Entity\NewsType;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\Uid\Uuid;

/**
 * @extends ServiceEntityRepository<NewsType>
 *
 * @method NewsType|null find($id, $lockMode = null, $lockVersion = null)
 * @method NewsType|null findOneBy(array $criteria, array $orderBy = null)
 * @method NewsType[]    findAll()
 * @method NewsType[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class NewsTypeRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, NewsType::class);
    }

    public function getById(string $id): ?NewsType
    {
        return $this->find(new Uuid($id));
    }
}
