<?php

namespace App\Repository\Interface;

use App\Entity\Restaurant;

interface RestaurantRepositoryInterface
{
    public function getAll(int $page, int $limit, string $restaurantTypeId, string $kitchenId): array;

    public function getCount(): int;

    public function getById(string $id): Restaurant|null;

    public function create(Restaurant $restaurant): Restaurant;

    public function restaurantExists(string $id): bool;

    public function delete(string $id): void;
}