<?php

namespace App\Repository\Interface;

use App\Entity\News;

interface NewsRepositoryInterface
{
    public function getAll(int $page, int $limit, string|null $newsCategory): array;
    public function getCount(): int;
    public function getMainNews(): News;
    public function getNewsById(string $newsId): News|null;
    public function getById(string $id): News|null;

    public function create(News $news): News;

    public function newsExists(string $id): bool;

    public function delete(string $id): void;
}