<?php

namespace App\Model;

use DateTimeImmutable;
use Symfony\Component\Uid\Uuid;

class Review
{
    private Uuid $id;
    private DateTimeImmutable $date;
    private int $score;
    private string $text;
    private string $userName;

    public function __construct(
        Uuid $id,
        DateTimeImmutable $date,
        int $score,
        string $text,
        string $userName
    ) {
        $this->id = $id;
        $this->date = $date;
        $this->score = $score;
        $this->text = $text;
        $this->userName = $userName;
    }

    public function getId(): Uuid
    {
        return $this->id;
    }

    public function getDate(): DateTimeImmutable
    {
        return $this->date;
    }

    public function getScore(): int
    {
        return $this->score;
    }

    public function getText(): string
    {
        return $this->text;
    }

    public function getUserName(): string
    {
        return $this->userName;
    }
}