<?php

namespace App\Model;

use Symfony\Component\Uid\Uuid;

class NewsListingElement
{
    private Uuid $id;
    private string $name;
    private string $description;
    private File $image;
    private string $createAt;
    private string $detailLink;

    public function __construct(
        Uuid $id,
        string $name,
        string $description,
        File $image,
        string $createAt,
        string $detailLink
    ) {
        $this->id = $id;
        $this->name = $name;
        $this->description = $description;
        $this->image = $image;
        $this->createAt = $createAt;
        $this->detailLink = $detailLink;
    }

    public function getId(): Uuid
    {
        return $this->id;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function getDescription(): string
    {
        return $this->description;
    }

    public function getImage(): File
    {
        return $this->image;
    }

    public function getCreateAt(): string
    {
        return $this->createAt;
    }

    public function getDetailLink(): string
    {
        return $this->detailLink;
    }
}