<?php

namespace App\Entity;

use App\Repository\RestaurantRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Bridge\Doctrine\Types\UuidType;
use Symfony\Component\Uid\Uuid;

#[ORM\Entity(repositoryClass: RestaurantRepository::class)]
class Restaurant
{
    #[ORM\Id]
    #[ORM\Column(type: UuidType::NAME, unique: true)]
    #[ORM\GeneratedValue(strategy: 'CUSTOM')]
    #[ORM\CustomIdGenerator(class: 'doctrine.uuid_generator')]
    private ?Uuid $id = null;

    #[ORM\Column(length: 255)]
    private ?string $name = null;

    #[ORM\Column(length: 255)]
    private ?string $code = null;

    #[ORM\Column]
    private ?bool $active = null;

    #[ORM\Column]
    private ?int $sort = null;

    #[ORM\Column(type: Types::DATETIME_IMMUTABLE)]
    private ?\DateTimeInterface $createAt = null;

    #[ORM\Column(type: Types::DATETIME_IMMUTABLE)]
    private ?\DateTimeInterface $updateAt = null;

    #[ORM\Column(type: 'simple_array')]
    private array $coordinates = [];

    #[ORM\ManyToOne(fetch: 'EAGER', inversedBy: 'restaurants')]
    #[ORM\JoinColumn(nullable: false)]
    private ?RestaurantType $typeId = null;

    #[ORM\ManyToOne(fetch: 'EAGER', inversedBy: 'restaurants')]
    #[ORM\JoinColumn(nullable: false)]
    private ?Settlement $settlementId = null;

    #[ORM\Column(type: Types::TEXT)]
    private ?string $description = null;

    #[ORM\Column(length: 255)]
    private ?string $checkPrice = null;

    #[ORM\Column(type: Types::TEXT)]
    private ?string $checkInfo = null;

    /**
     * @var Collection<Uuid, Kitchen>
     */
    #[ORM\OneToMany(targetEntity: Kitchen::class, mappedBy: 'restaurant', fetch: 'EAGER')]
    private Collection $kitchen;

    #[ORM\Column]
    private array $phone = [];

    #[ORM\Column]
    private array $email = [];

    #[ORM\Column]
    private array $address = [];

    /**
     * @var Collection<Uuid, Tags>
     */
    #[ORM\OneToMany(targetEntity: Tags::class, mappedBy: 'restaurant', fetch: 'EAGER')]
    private Collection $tags;

    #[ORM\Column(length: 255)]
    private ?string $site = null;

    #[ORM\Column(length: 255)]
    private ?string $previewImage = null;

    #[ORM\Column(length: 255)]
    private ?string $detailImage = null;

    #[ORM\Column(type: Types::TEXT)]
    private ?string $howToFind = null;

    #[ORM\ManyToOne(fetch: 'EAGER')]
    #[ORM\JoinColumn(nullable: false)]
    private ?Seo $seo = null;

    #[ORM\OneToOne(fetch: 'EAGER')]
    #[ORM\JoinColumn(nullable: false)]
    private ?File $file = null;

    public function __construct()
    {
        $this->kitchen = new ArrayCollection();
        $this->tags = new ArrayCollection();
    }

    public function getId(): ?Uuid
    {
        return $this->id;
    }

    public function setId(Uuid $id): self
    {
        $this->id = $id;
        return $this;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): static
    {
        $this->name = $name;

        return $this;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(string $code): static
    {
        $this->code = $code;

        return $this;
    }

    public function isActive(): ?bool
    {
        return $this->active;
    }

    public function setActive(bool $active): static
    {
        $this->active = $active;

        return $this;
    }

    public function getSort(): ?int
    {
        return $this->sort;
    }

    public function setSort(int $sort): static
    {
        $this->sort = $sort;

        return $this;
    }

    public function getCreateAt(): ?\DateTimeInterface
    {
        return $this->createAt;
    }

    public function setCreateAt(\DateTimeInterface $createAt): static
    {
        $this->createAt = $createAt;

        return $this;
    }

    public function getUpdateAt(): ?\DateTimeInterface
    {
        return $this->updateAt;
    }

    public function setUpdateAt(\DateTimeInterface $updateAt): static
    {
        $this->updateAt = $updateAt;

        return $this;
    }

    public function getCoordinates(): array
    {
        return $this->coordinates;
    }

    public function setCoordinates(array $coordinates): static
    {
        $this->coordinates = $coordinates;

        return $this;
    }

    public function getTypeId(): ?RestaurantType
    {
        return $this->typeId;
    }

    public function setTypeId(?RestaurantType $typeId): static
    {
        $this->typeId = $typeId;

        return $this;
    }

    public function getSettlementId(): ?Settlement
    {
        return $this->settlementId;
    }

    public function setSettlementId(?Settlement $settlementId): static
    {
        $this->settlementId = $settlementId;

        return $this;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function setDescription(string $description): static
    {
        $this->description = $description;

        return $this;
    }

    public function getCheckPrice(): ?string
    {
        return $this->checkPrice;
    }

    public function setCheckPrice(string $checkPrice): static
    {
        $this->checkPrice = $checkPrice;

        return $this;
    }

    public function getCheckInfo(): ?string
    {
        return $this->checkInfo;
    }

    public function setCheckInfo(string $checkInfo): static
    {
        $this->checkInfo = $checkInfo;

        return $this;
    }

    /**
     * @return Collection<Uuid, Kitchen>
     */
    public function getKitchen(): Collection
    {
        return $this->kitchen;
    }

    public function addKitchen(Kitchen $kitchen): static
    {
        if (!$this->kitchen->contains($kitchen)) {
            $this->kitchen->add($kitchen);
            $kitchen->setRestaurant($this);
        }

        return $this;
    }

    public function removeKitchen(Kitchen $kitchen): static
    {
        if ($this->kitchen->removeElement($kitchen)) {
            // set the owning side to null (unless already changed)
            if ($kitchen->getRestaurant() === $this) {
                $kitchen->setRestaurant(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection<Uuid, Tags>
     */
    public function getTags(): Collection
    {
        return $this->tags;
    }

    public function addTag(Tags $tag): static
    {
        if (!$this->tags->contains($tag)) {
            $this->tags->add($tag);
            $tag->setRestaurant($this);
        }

        return $this;
    }

    public function removeTag(Tags $tag): static
    {
        if ($this->tags->removeElement($tag)) {
            // set the owning side to null (unless already changed)
            if ($tag->getRestaurant() === $this) {
                $tag->setRestaurant(null);
            }
        }

        return $this;
    }

    public function getSite(): ?string
    {
        return $this->site;
    }

    public function setSite(string $site): static
    {
        $this->site = $site;

        return $this;
    }

    public function getPreviewImage(): ?string
    {
        return $this->previewImage;
    }

    public function setPreviewImage(string $previewImage): static
    {
        $this->previewImage = $previewImage;

        return $this;
    }

    public function getDetailImage(): ?string
    {
        return $this->detailImage;
    }

    public function setDetailImage(string $detailImage): static
    {
        $this->detailImage = $detailImage;

        return $this;
    }

    public function getHowToFind(): ?string
    {
        return $this->howToFind;
    }

    public function setHowToFind(string $howToFind): static
    {
        $this->howToFind = $howToFind;

        return $this;
    }

    public function getSeo(): ?Seo
    {
        return $this->seo;
    }

    public function setSeo(?Seo $seo): static
    {
        $this->seo = $seo;

        return $this;
    }

    public function setPhone(array $phone): static
    {
        $this->phone = $phone;

        return $this;
    }

    public function setEmail(array $email): static
    {
        $this->email = $email;

        return $this;
    }

    public function setAddress(array $address): static
    {
        $this->address = $address;

        return $this;
    }

    public function getFile(): ?File
    {
        return $this->file;
    }

    public function setFile(File $file): static
    {
        $this->file = $file;

        return $this;
    }

    public function getPhone(): array
    {
        return $this->phone;
    }

    public function getEmail(): array
    {
        return $this->email;
    }

    public function getAddress(): array
    {
        return $this->address;
    }
}
