<?php

namespace App\Controller;

use App\Action\Functions;
use App\Service\FileUploader;
use App\Requests\{
    SortPriceRequest,
    SearchRequest,
    UniqElementsRequest,
    MenuRequest,
    HowDaysToNyRequest,
    CountFriday13Request,
    DiffDaysRequest
};
use DateTimeImmutable;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Attribute\Route;

class HomeController extends AbstractController
{
    public function __construct(private Functions $functions) {}

    #[Route('/sortPrice', name: 'sortPrice', methods: ['POST'])]
    public function sortPrice(SortPriceRequest $request): Response
    {
        $array = $this->functions->sortPrice($request->getRequest()->toArray()['items']);
        return $this->json($array);
    }

    #[Route('/search', name: 'search', methods: ['POST'])]
    public function search(SearchRequest $request): Response
    {
        $requestData = $request->getRequest()->toArray();
        $id = $request->getRequest()->get('id');
        $result = $this->functions->search($requestData['items'], $id);
        return $this->json($result);
    }

    #[Route('/uniqElements', name: 'uniqElements', methods: ['POST'])]
    public function uniqElements(UniqElementsRequest $request): Response
    {
        $result = $this->functions->uniqElements($request->getRequest()->toArray()['items']);
        return $this->json($result);
    }

    #[Route('/prepareMenu', name: 'prepareMenu', methods: ['POST'])]
    public function prepareMenu(MenuRequest $request): Response
    {
        $result = $this->functions->prepareMenu($request->getRequest()->toArray()['items']);
        return $this->json($result);
    }

    #[Route('/howDaysToNy', name: 'howDaysToNy', methods: ['GET'])]
    public function howDaysToNy(HowDaysToNyRequest $request): Response
    {
        $date = $request->getRequest()->get('date');
        try {
            $result = $this->functions->howDaysToNy(new DateTimeImmutable($date));
        } catch (\Exception $e) {
            return new Response($e->getMessage());
        }
        return $this->json(["Days before NY:" => $result]);
    }

    #[Route('/countFriday13', name: 'countFriday13', methods: ['GET'])]
    public function countFriday13(CountFriday13Request $request): Response
    {
        $year = $request->getRequest()->get('year');
        $fridays = array();
        try {
            foreach ($this->functions->countFriday13($year) as $date) {
                $fridays[] = $date->format("Y-m-d l");
            }
        } catch (\Exception $e) {
            return new Response($e->getMessage());
        }
        return $this->json($fridays);
    }

    #[Route('/diffDays', name: 'diffDays')] // 01-01-2024
    public function diffDays(DiffDaysRequest $request): Response
    {
        try {
            $result = $this->functions->diffDays(
                new DateTimeImmutable($request->getRequest()->get('startDate')),
                new DateTimeImmutable($request->getRequest()->get('endDate')),
            );
            return $this->json(["The difference of days:" => $result]);
        } catch (\Exception $e) {
            return new Response($e->getMessage());
        }
    }

    #[Route('/readLogFile', name: 'readLogFile')]
    public function readLogFile(Request $request, FileUploader $fileUploader): Response
    {
        $file = $request->files->get('file');
        $fileName = $fileUploader->upload($file);
        $text = $this->functions->readLogFile($fileName);
        $response = new JsonResponse($text);
        $response->setEncodingOptions(JSON_UNESCAPED_UNICODE);
        return $response;
    }

    #[Route('/func9/{fileName}', name: 'func9')]
    public function func9(string $fileName): Response // text.txt
    {
        $filePath = $this->getParameter('kernel.project_dir') . "/public/files/" . $fileName;
        $text = "";
        foreach ($this->functions->readFileLineByLine($filePath) as $line) {
            $text .= $line;
        }
        $response = new JsonResponse($text);
        $response->setEncodingOptions(JSON_UNESCAPED_UNICODE);
        return $response;
    }
}
