<?php

declare(strict_types=1);

namespace App\Tests;

use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

class RestaurantControllerTest extends WebTestCase
{
    public function testRestaurants(): void
    {
        $client = static::createClient();
        $content = $client->request('GET', '/api/v1/restaurants?page=1&limit=12');
        $actual = json_decode($client->getResponse()->getContent(), true, 512, JSON_THROW_ON_ERROR);
        $expect = '{
    "pagination": {
        "currentPage": 1,
        "pages": 1,
        "pageSize": 12
    },
    "list": [
        {
            "id": 1,
            "name": "Ресторан «Арктика»",
            "code": "restoran-arktika",
            "type": {
                "id": 1,
                "name": "Ресторан",
                "code": "restoran"
            },
            "check": "bla bla",
            "image": {
                "id": 1,
                "name": "name",
                "description": "description",
                "size": 10,
                "type": "jpg",
                "url": "/upload/preview.png"
            },
            "detailLink": "https://visityamal.ru/"
        }
    ],
    "filterVariants": {
        "type": [
            {
                "id": 1,
                "name": "Ресторан",
                "code": "restoran"
            }
        ],
        "kitchen": [
            {
                "id": 1,
                "name": "Азиатская"
            }
        ]
    }
}';
        self::assertResponseIsSuccessful();
        self::assertJsonStringEqualsJsonString($expect, $actual);
    }
}
