<?php

namespace App\Requests;

use Symfony\Component\Validator\Constraints as Assert;

class RestaurantListRequest extends BaseRequest
{
    #[Assert\Type('int')]
    #[Assert\NotBlank]
    public $page;
    #[Assert\Type('int')]
    #[Assert\NotBlank]
    public $limit;
    #[Assert\Type('int')]
    public $restaurant_type_id;
    #[Assert\Type('int')]
    public $kitchen_id;

    protected function populate(): void
    {
        foreach ($this->getRequest()->query as $property => $value) {
            if (property_exists($this, $property)) {
                $this->{$property} = ctype_digit($value) ? (int)$value : $value;
            }
        }
    }
}