<?php

namespace App\Model;


use Ramsey\Collection\Collection;

class RestaurantList
{
    private Pagination $pagination;
    /**
     * @var Collection<RestaurantListingElement>
     */
    private Collection $list;
    private RestaurantFilterVariants $filterVariants;

    public function __construct(
        Pagination $pagination,
        Collection $list,
        RestaurantFilterVariants $filterVariants
    ) {
        $this->pagination = $pagination;
        $this->list = $list;
        $this->filterVariants = $filterVariants;
    }

    public function getPagination(): Pagination
    {
        return $this->pagination;
    }

    public function getList(): Collection
    {
        return $this->list;
    }

    public function getFilterVariants(): RestaurantFilterVariants
    {
        return $this->filterVariants;
    }
}