<?php

namespace App\Model;

use Ramsey\Collection\Collection;

class RestaurantDetailElement
{
    private int $id;
    private string $name;
    private string $code;
    private string $coordinates;
    private RestaurantType $type;
    private string $check;
    private string $checkInfo;
    /**
     * @var Collection<KitchenType>
     */
    private Collection $kitchen;
    /**
     * @var Collection<string>
     */
    private Collection $phone;
    /**
     * @var Collection<string>
     */
    private Collection $email;
    /**
     * @var Collection<string>
     */
    private Collection $address;
    /**
     * @var Collection<Tag>
     */
    private Collection $tags;
    private string $site;
    private File $image;
    /**
     * @var Collection<File>
     */
    private Collection $gallery;
    private string $seoTitle;
    private string $seoDescription;
    private string $seoKeywords;

    public function __construct(
        int $id,
        string $name,
        string $code,
        string $coordinates,
        RestaurantType $type,
        string $check,
        string $checkInfo,
        Collection $kitchen,
        Collection $phone,
        Collection $email,
        Collection $address,
        Collection $tags,
        string $site,
        File $image,
        Collection $gallery,
        string $seoTitle,
        string $seoDescription,
        string $seoKeywords
    ) {
        $this->id = $id;
        $this->name = $name;
        $this->code = $code;
        $this->coordinates = $coordinates;
        $this->type = $type;
        $this->check = $check;
        $this->checkInfo = $checkInfo;
        $this->kitchen = $kitchen;
        $this->phone = $phone;
        $this->email = $email;
        $this->address = $address;
        $this->tags = $tags;
        $this->site = $site;
        $this->image = $image;
        $this->gallery = $gallery;
        $this->seoTitle = $seoTitle;
        $this->seoDescription = $seoDescription;
        $this->seoKeywords = $seoKeywords;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function getCode(): string
    {
        return $this->code;
    }

    public function getCoordinates(): string
    {
        return $this->coordinates;
    }

    public function getType(): RestaurantType
    {
        return $this->type;
    }

    public function getCheck(): string
    {
        return $this->check;
    }

    public function getCheckInfo(): string
    {
        return $this->checkInfo;
    }

    public function getKitchen(): Collection
    {
        return $this->kitchen;
    }

    public function getPhone(): Collection
    {
        return $this->phone;
    }

    public function getEmail(): Collection
    {
        return $this->email;
    }

    public function getAddress(): Collection
    {
        return $this->address;
    }

    public function getTags(): Collection
    {
        return $this->tags;
    }

    public function getSite(): string
    {
        return $this->site;
    }

    public function getImage(): File
    {
        return $this->image;
    }

    public function getGallery(): Collection
    {
        return $this->gallery;
    }

    public function getSeoTitle(): string
    {
        return $this->seoTitle;
    }

    public function getSeoDescription(): string
    {
        return $this->seoDescription;
    }

    public function getSeoKeywords(): string
    {
        return $this->seoKeywords;
    }
}