<?php

namespace App\Requests;

use Symfony\Component\Validator\Constraints as Assert;

class CountFriday13Request extends BaseRequest
{
    #[Assert\Type('int')]
    #[Assert\Positive]
    public int $year;

    protected function populate(): void
    {
        foreach ($this->getRequest()->query->all() as $property => $value) {
            if (property_exists($this, $property)) {
                $this->{$property} = $value;
            }
        }
    }
}