<?php

namespace App\Controller;

use App\Action\Functions;
use App\Requests\{
    SortPriceRequest,
    SearchRequest,
    UniqElementsRequest,
    MenuRequest,
    CountFriday13Request
};
use DateTimeImmutable;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

class HomeController extends AbstractController
{
    public function __construct(private Functions $functions) {}

    #[Route('/sortPrice', name: 'sortPrice', methods: ['POST'])]
    public function sortPrice(SortPriceRequest $request): Response
    {
        $array = $this->functions->sortPrice($request->getRequest()->toArray()['items']);
        return $this->json($array);
    }

    #[Route('/search', name: 'search', methods: ['POST'])]
    public function search(SearchRequest $request): Response
    {
        $array = $request->getRequest()->toArray()['items'];
        $id = $request->getRequest()->query->get('id');
        $result = $this->functions->search($array, $id);
        return $this->json($result);
    }

    #[Route('/uniqElements', name: 'uniqElements', methods: ['POST'])]
    public function uniqElements(UniqElementsRequest $request): Response
    {
        $result = $this->functions->uniqElements($request->getRequest()->toArray()['items']);
        return $this->json($result);
    }

    #[Route('/prepareMenu', name: 'prepareMenu', methods: ['POST'])]
    public function prepareMenu(MenuRequest $request): Response
    {
        $result = $this->functions->prepareMenu($request->getRequest()->toArray()['items']);
        return $this->json($result);
    }

    #[Route(
        '/howDaysToNy/{day}/{month}/{year}',
        name: 'howDaysToNy',
        requirements: [
            'day' => '(?<!-)(?<!\d)\d+',
            'month' => '(?<!-)(?<!\d)\d+',
            'year' => '(?<!-)(?<!\d)\d+'
        ],
        methods: ['GET']
    )]
    public function howDaysToNy(int $day, int $month, int $year): Response
    {
        $dateAsString = $year . "-" . $month . "-" . $day;
        try {
            $result = $this->functions->howDaysToNy(new DateTimeImmutable($dateAsString));
        } catch (\Exception $e) {
            return new Response($e->getMessage());
        }
        return $this->json(["Days before NY:" => $result]);
    }

    #[Route('/countFriday13', name: 'countFriday13', methods: ['GET'])]
    public function countFriday13(CountFriday13Request $request): Response
    {
        $year = $request->getRequest()->get('year');
        $fridays = array();
        try {
            foreach ($this->functions->countFriday13($year) as $date) {
                $fridays[] = $date->format("Y-m-d l");
            }
        } catch (\Exception $e) {
            return new Response($e->getMessage());
        }
        return $this->json($fridays);
    }
}
