<?php

namespace App\Validation;

use Symfony\Component\Validator\Validation;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\Validator\ConstraintViolationListInterface;

class ArrayValidation
{
    public static function validate(array $array): ConstraintViolationListInterface
    {
        $validator = Validation::createValidator();
        $constraints = new Assert\Optional([
            new Assert\Collection([
                new Assert\Optional([
                    new Assert\Type('array'),
                    new Assert\Collection([
                        'name' => new Assert\Type('string'),
                        'depth' => new Assert\Type('int'),
                    ])
                ])
            ])
        ]);
        return $validator->validate($array, $constraints);
    }
}