<?php

namespace App\Controller;

use DateInterval;
use DatePeriod;
use DateTime;
use DateTimeImmutable;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

class HomeController extends AbstractController
{
    private function diffDays(DateTimeImmutable $dateStart, DateTimeImmutable $dateEnd): int {
        return date_diff($dateStart, $dateEnd)->format("%a") ;
    }

    #[Route('/{startDate}/{endDate}', name: 'home')] // 01-01-2024
    public function home(string $startDate, string $endDate): Response
    {
        $countDays = $this->diffDays(new DateTimeImmutable($startDate), new DateTimeImmutable($endDate));
        return $this->render('home.html.twig', ['count' => $countDays]);
    }
}
