<?php

namespace App\Controller;

use App\Action\Functions;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

class HomeController extends AbstractController
{
    private Functions $functions;

    public function __construct(Functions $functions)
    {
        $this->functions = $functions;
    }

    #[Route('/{fileName}', name: 'home')]
    public function home(string $fileName): Response // text.txt
    {
        $filePath = $this->getParameter('kernel.project_dir') . "/public/files/";
        $text = $this->functions->readLogFile($filePath . $fileName);
        $response = new JsonResponse($text);
        $response->setEncodingOptions(JSON_UNESCAPED_UNICODE);
        return $response;
    }
}
