<?php

namespace App\Validation;

use Symfony\Component\Validator\Validation;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\Validator\ConstraintViolationListInterface;

class ArrayValidation
{
    public static function validate(array $array): ConstraintViolationListInterface
    {
        $validator = Validation::createValidator();
        $constraints = new Assert\Optional([
            new Assert\Collection([
                new Assert\Optional([
                    new Assert\Type('array'),
                    new Assert\Collection([
                         new Assert\Type('string'),
                        new Assert\Type('string'),
                    ])
                ])
            ])
        ]);
        return $validator->validate($array, $constraints);
    }
}